/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.pinot.client.BrokerResponse;
import org.apache.pinot.client.Connection;
import org.apache.pinot.client.ConnectionFactory;
import org.apache.pinot.client.PinotClientException;
import org.apache.pinot.client.PinotClientTransport;
import org.apache.pinot.client.PinotClientTransportFactory;
import org.apache.pinot.client.Request;
import org.apache.pinot.client.ResultSet;
import org.apache.pinot.client.ResultSetGroup;
import org.apache.pinot.spi.utils.JsonUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ResultSetGroupTest {
    private final DummyJsonTransport _dummyJsonTransport = new DummyJsonTransport();

    @Test
    public void testDeserializeSelectionResultSet() {
        ResultSetGroup resultSetGroup = this.getResultSet("selection.json");
        ResultSet resultSet = resultSetGroup.getResultSet(0);
        Assert.assertEquals((int)resultSetGroup.getResultSetCount(), (int)1, (String)"Expected one result set for selection query");
        Assert.assertEquals((int)resultSet.getRowCount(), (int)24, (String)"Mismatched selection query length");
        Assert.assertEquals((int)resultSet.getInt(0, 0), (int)84);
        Assert.assertEquals((long)resultSet.getLong(1, 0), (long)202L);
        Assert.assertEquals((String)resultSet.getString(2, 0), (String)"95");
        Assert.assertEquals((int)resultSet.getInt(0, 78), (int)2014);
        Assert.assertEquals((int)resultSet.getColumnCount(), (int)79);
        Assert.assertEquals((String)resultSet.getColumnName(0), (String)"ActualElapsedTime");
        Assert.assertEquals((String)resultSet.getColumnName(1), (String)"AirTime");
        Assert.assertEquals((long)115545L, (long)resultSetGroup.getExecutionStats().getTotalDocs());
        Assert.assertEquals((long)82L, (long)resultSetGroup.getExecutionStats().getTimeUsedMs());
        Assert.assertEquals((long)24L, (long)resultSetGroup.getExecutionStats().getNumDocsScanned());
    }

    @Test
    public void testDeserializeAggregationResultSet() {
        ResultSetGroup resultSetGroup = this.getResultSet("aggregation.json");
        Assert.assertEquals((int)resultSetGroup.getResultSetCount(), (int)1, (String)"Result set count mismatch");
        ResultSet resultSet = resultSetGroup.getResultSet(0);
        Assert.assertEquals((int)resultSet.getGroupKeyLength(), (int)0, (String)"Expected 0 length group key for non-group by aggregation query");
        Assert.assertEquals((int)resultSet.getRowCount(), (int)1, (String)"Result group length mismatch");
        Assert.assertEquals((int)resultSet.getInt(0), (int)36542, (String)"Mismatched int value");
        Assert.assertEquals((long)resultSet.getLong(0), (long)36542L, (String)"Mismatched long value");
        Assert.assertEquals((String)resultSet.getString(0), (String)"36542", (String)"Mismatched String value");
        Assert.assertEquals((int)resultSet.getColumnCount(), (int)1);
        Assert.assertEquals((String)resultSet.getColumnName(0), (String)"count_star");
    }

    @Test
    public void testDeserializeAggregationGroupByResultSet() {
        ResultSetGroup resultSetGroup = this.getResultSet("aggregationGroupBy.json");
        Assert.assertEquals((int)resultSetGroup.getResultSetCount(), (int)1, (String)"Result set count mismatch");
        ResultSet resultSet = resultSetGroup.getResultSet(0);
        Assert.assertEquals((int)resultSet.getGroupKeyLength(), (int)1, (String)"Group key length mismatch");
        Assert.assertEquals((int)resultSet.getRowCount(), (int)10, (String)"Result group length mismatch");
        Assert.assertEquals((int)resultSet.getGroupKeyInt(0, 0), (int)30194);
        Assert.assertEquals((long)resultSet.getGroupKeyLong(1, 0), (long)31057L);
        Assert.assertEquals((String)resultSet.getGroupKeyString(2, 0), (String)"32467");
        Assert.assertEquals((int)resultSet.getInt(0), (int)3604);
        Assert.assertEquals((long)resultSet.getLong(1), (long)1804L);
        Assert.assertEquals((String)resultSet.getString(2), (String)"1316");
        Assert.assertEquals((int)resultSet.getColumnCount(), (int)1);
        Assert.assertEquals((String)resultSet.getColumnName(0), (String)"count_star");
    }

    @Test
    public void testDeserializeExceptionResultSet() {
        try {
            this.getResultSet("exception.json");
            Assert.fail((String)"Execute should have thrown an exception");
        }
        catch (PinotClientException pinotClientException) {
            // empty catch block
        }
    }

    @Test
    public void testDeserializeExceptionResultSetSkipFail() {
        try {
            ResultSetGroup resultSet = this.getResultSetSkipError("exception.json");
            Assert.assertTrue((resultSet.getExceptions().size() > 0 ? 1 : 0) != 0);
        }
        catch (PinotClientException e) {
            Assert.fail((String)"Execute should have thrown an exception");
        }
    }

    private ResultSetGroup getResultSet(String resourceName) {
        this._dummyJsonTransport._resource = resourceName;
        Connection connection = ConnectionFactory.fromHostList(Collections.singletonList("dummy"), (PinotClientTransport)this._dummyJsonTransport);
        return connection.execute("dummy");
    }

    private ResultSetGroup getResultSetSkipError(String resourceName) {
        this._dummyJsonTransport._resource = resourceName;
        Properties props = new Properties();
        props.setProperty("failOnExceptions", "false");
        Connection connection = ConnectionFactory.fromHostList((Properties)props, Collections.singletonList("dummy"), (PinotClientTransport)this._dummyJsonTransport);
        return connection.execute("dummy");
    }

    class DummyJsonTransportFactory
    implements PinotClientTransportFactory {
        DummyJsonTransportFactory() {
        }

        public PinotClientTransport buildTransport() {
            return ResultSetGroupTest.this._dummyJsonTransport;
        }
    }

    static class DummyJsonTransport
    implements PinotClientTransport {
        public String _resource;

        DummyJsonTransport() {
        }

        public BrokerResponse executeQuery(String brokerAddress, String query) throws PinotClientException {
            try {
                StringBuilder builder = new StringBuilder();
                InputStream stream = this.getClass().getResourceAsStream(this._resource);
                int lastByte = stream.read();
                while (lastByte != -1) {
                    builder.append((char)lastByte);
                    lastByte = stream.read();
                }
                String jsonText = builder.toString();
                return BrokerResponse.fromJson((JsonNode)JsonUtils.stringToJsonNode((String)jsonText));
            }
            catch (Exception e) {
                Assert.fail((String)"Unexpected exception", (Throwable)e);
                return null;
            }
        }

        public Future<BrokerResponse> executeQueryAsync(String brokerAddress, String query) throws PinotClientException {
            return null;
        }

        public BrokerResponse executeQuery(String brokerAddress, Request request) throws PinotClientException {
            return this.executeQuery(brokerAddress, request.getQuery());
        }

        public Future<BrokerResponse> executeQueryAsync(String brokerAddress, Request request) throws PinotClientException {
            return null;
        }

        public void close() throws PinotClientException {
        }
    }
}

