/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import java.util.Collections;
import java.util.concurrent.Future;
import org.apache.pinot.client.BrokerResponse;
import org.apache.pinot.client.BrokerSelector;
import org.apache.pinot.client.Connection;
import org.apache.pinot.client.ConnectionFactory;
import org.apache.pinot.client.PinotClientException;
import org.apache.pinot.client.PinotClientTransport;
import org.apache.pinot.client.PinotClientTransportFactory;
import org.apache.pinot.client.PreparedStatement;
import org.apache.pinot.client.Request;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PreparedStatementTest {
    private final DummyPinotClientTransport _dummyPinotClientTransport = new DummyPinotClientTransport();

    @Test
    public void testPreparedStatementWithDynamicBroker() {
        BrokerSelector mockBrokerSelector = (BrokerSelector)Mockito.mock(BrokerSelector.class);
        Mockito.when((Object)mockBrokerSelector.selectBroker(Mockito.anyString())).thenAnswer(i -> i.getArgument(0));
        Connection connection = new Connection(mockBrokerSelector, (PinotClientTransport)this._dummyPinotClientTransport);
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT foo FROM bar WHERE baz = ?");
        preparedStatement.setString(0, "'hello'");
        preparedStatement.execute();
        Assert.assertEquals((String)"SELECT foo FROM bar WHERE baz = '''hello'''", (String)this._dummyPinotClientTransport.getLastQuery());
        Assert.assertEquals((String)"bar", (String)this._dummyPinotClientTransport.getLastBrokerAddress());
        preparedStatement = connection.prepareStatement("SELECT bar FROM foo WHERE baz = ?");
        preparedStatement.setString(0, "'world'");
        preparedStatement.executeAsync();
        Assert.assertEquals((String)"SELECT bar FROM foo WHERE baz = '''world'''", (String)this._dummyPinotClientTransport.getLastQuery());
        Assert.assertEquals((String)"foo", (String)this._dummyPinotClientTransport.getLastBrokerAddress());
    }

    @Test
    public void testPreparedStatementEscaping() {
        Connection connection = ConnectionFactory.fromHostList(Collections.singletonList("dummy"), (PinotClientTransport)this._dummyPinotClientTransport);
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT foo FROM bar WHERE baz = ?");
        preparedStatement.setString(0, "'hello'");
        preparedStatement.execute();
        Assert.assertEquals((String)"SELECT foo FROM bar WHERE baz = '''hello'''", (String)this._dummyPinotClientTransport.getLastQuery());
    }

    class DummyPinotClientTransportFactory
    implements PinotClientTransportFactory {
        DummyPinotClientTransportFactory() {
        }

        public PinotClientTransport buildTransport() {
            return PreparedStatementTest.this._dummyPinotClientTransport;
        }
    }

    static class DummyPinotClientTransport
    implements PinotClientTransport {
        private String _lastBrokerAddress;
        private String _lastQuery;

        DummyPinotClientTransport() {
        }

        public BrokerResponse executeQuery(String brokerAddress, String query) throws PinotClientException {
            this._lastBrokerAddress = brokerAddress;
            this._lastQuery = query;
            return BrokerResponse.empty();
        }

        public Future<BrokerResponse> executeQueryAsync(String brokerAddress, String query) throws PinotClientException {
            this._lastBrokerAddress = brokerAddress;
            this._lastQuery = query;
            return null;
        }

        public BrokerResponse executeQuery(String brokerAddress, Request request) throws PinotClientException {
            this._lastBrokerAddress = brokerAddress;
            this._lastQuery = request.getQuery();
            return BrokerResponse.empty();
        }

        public Future<BrokerResponse> executeQueryAsync(String brokerAddress, Request request) throws PinotClientException {
            this._lastBrokerAddress = brokerAddress;
            this._lastQuery = request.getQuery();
            return null;
        }

        public String getLastQuery() {
            return this._lastQuery;
        }

        public String getLastBrokerAddress() {
            return this._lastBrokerAddress;
        }

        public void close() throws PinotClientException {
        }
    }
}

