/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.client.GroupByResultSet;
import org.apache.pinot.spi.utils.JsonUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GroupByResultSetTest {
    private JsonNode _mockJsonObject;
    private GroupByResultSet _groupByResultSetUnderTest;

    @BeforeMethod
    public void setUp() throws Exception {
        String jsonString = "{\"groupByResult\":[{\"value\":1, \"group\":[\"testGroup1\"]},{\"value\":2, \"group\":[\"testGroup2\"]}], \"groupByColumns\":[\"testGroupColumn\"], \"function\":\"testFunction\"}";
        this._mockJsonObject = JsonUtils.stringToJsonNode((String)jsonString);
        this._groupByResultSetUnderTest = new GroupByResultSet(this._mockJsonObject);
    }

    @Test
    public void testGetRowCount() {
        int result = this._groupByResultSetUnderTest.getRowCount();
        Assert.assertEquals((int)2, (int)result);
    }

    @Test
    public void testGetColumnCount() {
        int result = this._groupByResultSetUnderTest.getColumnCount();
        Assert.assertEquals((int)1, (int)result);
    }

    @Test
    public void testGetColumnName() {
        String result = this._groupByResultSetUnderTest.getColumnName(0);
        Assert.assertEquals((String)"testFunction", (String)result);
    }

    @Test
    public void testGetString() {
        String result = this._groupByResultSetUnderTest.getString(0, 0);
        Assert.assertEquals((String)"1", (String)result);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetStringExceptionState() {
        String result = this._groupByResultSetUnderTest.getString(0, 1);
    }

    @Test
    public void testGetGroupKeyLength() {
        int result = this._groupByResultSetUnderTest.getGroupKeyLength();
        Assert.assertEquals((int)1, (int)result);
    }

    @Test
    public void testGetGroupKeyString() {
        String result = this._groupByResultSetUnderTest.getGroupKeyString(0, 0);
        Assert.assertEquals((String)"testGroup1", (String)result);
    }

    @Test
    public void testGetGroupKeyColumnName() {
        String result = this._groupByResultSetUnderTest.getGroupKeyColumnName(0);
        Assert.assertEquals((String)"testGroupColumn", (String)result);
    }

    @Test(priority=1)
    public void testToString() {
        String result = this._groupByResultSetUnderTest.toString();
        Assert.assertNotEquals((Object)"", (Object)result);
    }
}

