/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.I0Itec.zkclient.ZkClient;
import org.apache.commons.io.IOUtils;
import org.apache.pinot.client.ExternalViewReader;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExternalViewReaderTest {
    @Mock
    private ZkClient _mockZkClient;
    private ExternalViewReader _externalViewReaderUnderTest;
    private final String _instanceConfigPlain = "{\n  \"id\": \"Broker_12.34.56.78_1234\",\n  \"simpleFields\": {\n    \"HELIX_ENABLED\": \"true\",\n    \"HELIX_ENABLED_TIMESTAMP\": \"1646486555646\",\n    \"HELIX_HOST\": \"first.pug-pinot-broker-headless\",\n    \"HELIX_PORT\": \"8099\"\n  },\n  \"mapFields\": {},\n  \"listFields\": {\n    \"TAG_LIST\": [\n      \"DefaultTenant_BROKER\"\n    ]\n  }\n}";
    private final String _instanceConfigTls = "{\n  \"id\": \"Broker_12.34.56.78_1234\",\n  \"simpleFields\": {\n    \"HELIX_ENABLED\": \"true\",\n    \"HELIX_ENABLED_TIMESTAMP\": \"1646486555646\",\n    \"HELIX_HOST\": \"first.pug-pinot-broker-headless\",\n    \"HELIX_PORT\": \"8099\",\n    \"PINOT_TLS_PORT\": \"8090\"  },\n  \"mapFields\": {},\n  \"listFields\": {\n    \"TAG_LIST\": [\n      \"DefaultTenant_BROKER\"\n    ]\n  }\n}";

    @BeforeMethod
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        final InputStream mockInputStream = IOUtils.toInputStream((String)"{\"mapFields\":{\"field1\":{\"Broker_12.34.56.78_1234\":\"ONLINE\"}}}", (String)"UTF-8");
        this._externalViewReaderUnderTest = (ExternalViewReader)Mockito.spy((Object)new ExternalViewReader(this._mockZkClient){

            protected ByteArrayInputStream getInputStream(byte[] brokerResourceNodeData) {
                return (ByteArrayInputStream)mockInputStream;
            }
        });
    }

    @Test
    public void testGetLiveBrokers() throws IOException {
        List<String> expectedResult = Arrays.asList("12.34.56.78:1234");
        Mockito.when((Object)this._mockZkClient.readData(Mockito.anyString(), Mockito.anyBoolean())).thenReturn((Object)"json".getBytes());
        List result = this._externalViewReaderUnderTest.getLiveBrokers();
        Assert.assertEquals(expectedResult, (Collection)result);
    }

    @Test
    public void testGetLiveBrokersExceptionState() throws IOException {
        List<String> expectedResult = Arrays.asList(new String[0]);
        Mockito.when((Object)this._mockZkClient.readData(Mockito.anyString(), Mockito.anyBoolean())).thenThrow(RuntimeException.class);
        List result = this._externalViewReaderUnderTest.getLiveBrokers();
        Assert.assertEquals(expectedResult, (Collection)result);
    }

    @Test
    public void testGetTableToBrokersMap() {
        HashMap<String, List<String>> expectedResult = new HashMap<String, List<String>>();
        expectedResult.put("field1", Arrays.asList("12.34.56.78:1234"));
        Mockito.when((Object)this._mockZkClient.readData(Mockito.anyString(), Mockito.anyBoolean())).thenReturn((Object)"json".getBytes());
        Map result = this._externalViewReaderUnderTest.getTableToBrokersMap();
        Assert.assertEquals(expectedResult, (Object)result);
    }

    @Test
    public void testGetTableToBrokersMapExceptionState() {
        HashMap expectedResult = new HashMap();
        Mockito.when((Object)this._mockZkClient.readData(Mockito.anyString(), Mockito.anyBoolean())).thenThrow(RuntimeException.class);
        Map result = this._externalViewReaderUnderTest.getTableToBrokersMap();
        Assert.assertEquals(expectedResult, (Object)result);
    }

    @Test
    public void testGetBrokersMapByInstanceConfig() {
        this.configureData("{\n  \"id\": \"Broker_12.34.56.78_1234\",\n  \"simpleFields\": {\n    \"HELIX_ENABLED\": \"true\",\n    \"HELIX_ENABLED_TIMESTAMP\": \"1646486555646\",\n    \"HELIX_HOST\": \"first.pug-pinot-broker-headless\",\n    \"HELIX_PORT\": \"8099\"\n  },\n  \"mapFields\": {},\n  \"listFields\": {\n    \"TAG_LIST\": [\n      \"DefaultTenant_BROKER\"\n    ]\n  }\n}", true);
        Map result = this._externalViewReaderUnderTest.getTableToBrokersMap();
        ImmutableMap expectedResult = ImmutableMap.of((Object)"field1", Arrays.asList("first.pug-pinot-broker-headless:8099"));
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }

    private void configureData(String instanceConfigPlain, boolean preferTls) {
        Mockito.when((Object)this._mockZkClient.readData("/EXTERNALVIEW/brokerResource", true)).thenReturn((Object)"json".getBytes());
        Mockito.when((Object)this._mockZkClient.readData("/CONFIGS/PARTICIPANT/Broker_12.34.56.78_1234", true)).thenReturn((Object)instanceConfigPlain.getBytes(StandardCharsets.UTF_8));
        this._externalViewReaderUnderTest._preferTlsPort = preferTls;
    }

    @Test
    public void testGetBrokerListByInstanceConfigDefault() {
        this.configureData("{\n  \"id\": \"Broker_12.34.56.78_1234\",\n  \"simpleFields\": {\n    \"HELIX_ENABLED\": \"true\",\n    \"HELIX_ENABLED_TIMESTAMP\": \"1646486555646\",\n    \"HELIX_HOST\": \"first.pug-pinot-broker-headless\",\n    \"HELIX_PORT\": \"8099\"\n  },\n  \"mapFields\": {},\n  \"listFields\": {\n    \"TAG_LIST\": [\n      \"DefaultTenant_BROKER\"\n    ]\n  }\n}", false);
        List brokers = this._externalViewReaderUnderTest.getLiveBrokers();
        Assert.assertEquals((Collection)brokers, Arrays.asList("first.pug-pinot-broker-headless:8099"));
    }

    @Test
    public void testGetBrokersMapByInstanceConfigTlsDefault() {
        this.configureData("{\n  \"id\": \"Broker_12.34.56.78_1234\",\n  \"simpleFields\": {\n    \"HELIX_ENABLED\": \"true\",\n    \"HELIX_ENABLED_TIMESTAMP\": \"1646486555646\",\n    \"HELIX_HOST\": \"first.pug-pinot-broker-headless\",\n    \"HELIX_PORT\": \"8099\",\n    \"PINOT_TLS_PORT\": \"8090\"  },\n  \"mapFields\": {},\n  \"listFields\": {\n    \"TAG_LIST\": [\n      \"DefaultTenant_BROKER\"\n    ]\n  }\n}", false);
        Map result = this._externalViewReaderUnderTest.getTableToBrokersMap();
        ImmutableMap expectedResult = ImmutableMap.of((Object)"field1", Arrays.asList("first.pug-pinot-broker-headless:8099"));
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }

    @Test
    public void testGetBrokerListByInstanceConfigTlsDefault() {
        this.configureData("{\n  \"id\": \"Broker_12.34.56.78_1234\",\n  \"simpleFields\": {\n    \"HELIX_ENABLED\": \"true\",\n    \"HELIX_ENABLED_TIMESTAMP\": \"1646486555646\",\n    \"HELIX_HOST\": \"first.pug-pinot-broker-headless\",\n    \"HELIX_PORT\": \"8099\",\n    \"PINOT_TLS_PORT\": \"8090\"  },\n  \"mapFields\": {},\n  \"listFields\": {\n    \"TAG_LIST\": [\n      \"DefaultTenant_BROKER\"\n    ]\n  }\n}", false);
        List brokers = this._externalViewReaderUnderTest.getLiveBrokers();
        Assert.assertEquals((Collection)brokers, Arrays.asList("first.pug-pinot-broker-headless:8099"));
    }

    @Test
    public void testGetBrokersMapByInstanceConfigDefault() {
        this.configureData("{\n  \"id\": \"Broker_12.34.56.78_1234\",\n  \"simpleFields\": {\n    \"HELIX_ENABLED\": \"true\",\n    \"HELIX_ENABLED_TIMESTAMP\": \"1646486555646\",\n    \"HELIX_HOST\": \"first.pug-pinot-broker-headless\",\n    \"HELIX_PORT\": \"8099\"\n  },\n  \"mapFields\": {},\n  \"listFields\": {\n    \"TAG_LIST\": [\n      \"DefaultTenant_BROKER\"\n    ]\n  }\n}", false);
        Map result = this._externalViewReaderUnderTest.getTableToBrokersMap();
        ImmutableMap expectedResult = ImmutableMap.of((Object)"field1", Arrays.asList("first.pug-pinot-broker-headless:8099"));
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }

    @Test
    public void testGetBrokerListByInstanceConfig() {
        this.configureData("{\n  \"id\": \"Broker_12.34.56.78_1234\",\n  \"simpleFields\": {\n    \"HELIX_ENABLED\": \"true\",\n    \"HELIX_ENABLED_TIMESTAMP\": \"1646486555646\",\n    \"HELIX_HOST\": \"first.pug-pinot-broker-headless\",\n    \"HELIX_PORT\": \"8099\"\n  },\n  \"mapFields\": {},\n  \"listFields\": {\n    \"TAG_LIST\": [\n      \"DefaultTenant_BROKER\"\n    ]\n  }\n}", true);
        List brokers = this._externalViewReaderUnderTest.getLiveBrokers();
        Assert.assertEquals((Collection)brokers, Arrays.asList("first.pug-pinot-broker-headless:8099"));
    }

    @Test
    public void testGetBrokersMapByInstanceConfigTls() {
        this.configureData("{\n  \"id\": \"Broker_12.34.56.78_1234\",\n  \"simpleFields\": {\n    \"HELIX_ENABLED\": \"true\",\n    \"HELIX_ENABLED_TIMESTAMP\": \"1646486555646\",\n    \"HELIX_HOST\": \"first.pug-pinot-broker-headless\",\n    \"HELIX_PORT\": \"8099\",\n    \"PINOT_TLS_PORT\": \"8090\"  },\n  \"mapFields\": {},\n  \"listFields\": {\n    \"TAG_LIST\": [\n      \"DefaultTenant_BROKER\"\n    ]\n  }\n}", true);
        Map result = this._externalViewReaderUnderTest.getTableToBrokersMap();
        ImmutableMap expectedResult = ImmutableMap.of((Object)"field1", Arrays.asList("first.pug-pinot-broker-headless:8090"));
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }

    @Test
    public void testGetBrokerListByInstanceConfigTls() {
        this.configureData("{\n  \"id\": \"Broker_12.34.56.78_1234\",\n  \"simpleFields\": {\n    \"HELIX_ENABLED\": \"true\",\n    \"HELIX_ENABLED_TIMESTAMP\": \"1646486555646\",\n    \"HELIX_HOST\": \"first.pug-pinot-broker-headless\",\n    \"HELIX_PORT\": \"8099\",\n    \"PINOT_TLS_PORT\": \"8090\"  },\n  \"mapFields\": {},\n  \"listFields\": {\n    \"TAG_LIST\": [\n      \"DefaultTenant_BROKER\"\n    ]\n  }\n}", true);
        List brokers = this._externalViewReaderUnderTest.getLiveBrokers();
        Assert.assertEquals((Collection)brokers, Arrays.asList("first.pug-pinot-broker-headless:8090"));
    }
}

