/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.client.ExecutionStats;
import org.apache.pinot.spi.utils.JsonUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExecutionStatsTest {
    private JsonNode _mockBrokerResponse;
    private ExecutionStats _executionStatsUnderTest;

    @BeforeMethod
    public void setUp() throws Exception {
        String json = "{\"numServersQueried\":10, \"numServersResponded\":10, \"numDocsScanned\":10, \"numEntriesScannedInFilter\":10, \"numEntriesScannedPostFilter\":10, \"numSegmentsQueried\":10, \"numSegmentsProcessed\":10, \"numSegmentsMatched\":10, \"numConsumingSegmentsQueried\":10, \"minConsumingFreshnessTimeMs\":10, \"totalDocs\":10, \"numGroupsLimitReached\":true, \"timeUsedMs\":10}";
        this._mockBrokerResponse = JsonUtils.stringToJsonNode((String)json);
        this._executionStatsUnderTest = new ExecutionStats(this._mockBrokerResponse);
    }

    @Test
    public void testGetNumServersQueried() {
        int result = this._executionStatsUnderTest.getNumServersQueried();
        Assert.assertEquals((int)10, (int)result);
    }

    @Test
    public void testGetNumServersResponded() {
        int result = this._executionStatsUnderTest.getNumServersResponded();
        Assert.assertEquals((int)10, (int)result);
    }

    @Test
    public void testGetNumDocsScanned() {
        long result = this._executionStatsUnderTest.getNumDocsScanned();
        Assert.assertEquals((long)10L, (long)result);
    }

    @Test
    public void testGetNumEntriesScannedInFilter() {
        long result = this._executionStatsUnderTest.getNumEntriesScannedInFilter();
        Assert.assertEquals((long)10L, (long)result);
    }

    @Test
    public void testGetNumEntriesScannedPostFilter() {
        long result = this._executionStatsUnderTest.getNumEntriesScannedPostFilter();
        Assert.assertEquals((long)10L, (long)result);
    }

    @Test
    public void testGetNumSegmentsQueried() {
        long result = this._executionStatsUnderTest.getNumSegmentsQueried();
        Assert.assertEquals((long)10L, (long)result);
    }

    @Test
    public void testGetNumSegmentsProcessed() {
        long result = this._executionStatsUnderTest.getNumSegmentsProcessed();
        Assert.assertEquals((long)10L, (long)result);
    }

    @Test
    public void testGetNumSegmentsMatched() {
        long result = this._executionStatsUnderTest.getNumSegmentsMatched();
        Assert.assertEquals((long)10L, (long)result);
    }

    @Test
    public void testGetNumConsumingSegmentsQueried() {
        long result = this._executionStatsUnderTest.getNumConsumingSegmentsQueried();
        Assert.assertEquals((long)10L, (long)result);
    }

    @Test
    public void testGetMinConsumingFreshnessTimeMs() {
        long result = this._executionStatsUnderTest.getMinConsumingFreshnessTimeMs();
        Assert.assertEquals((long)10L, (long)result);
    }

    @Test
    public void testGetTotalDocs() {
        long result = this._executionStatsUnderTest.getTotalDocs();
        Assert.assertEquals((long)10L, (long)result);
    }

    @Test
    public void testIsNumGroupsLimitReached() {
        boolean result = this._executionStatsUnderTest.isNumGroupsLimitReached();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testGetTimeUsedMs() {
        long result = this._executionStatsUnderTest.getTimeUsedMs();
        Assert.assertEquals((long)10L, (long)result);
    }

    @Test
    public void testToString() {
        String result = this._executionStatsUnderTest.toString();
        Assert.assertNotEquals((Object)"", (Object)result);
    }

    @Test
    public void testFromJson() {
        ExecutionStats result = ExecutionStats.fromJson((JsonNode)this._mockBrokerResponse);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)10, (int)result.getNumServersQueried());
    }
}

