/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.I0Itec.zkclient.ZkClient;
import org.apache.pinot.client.DynamicBrokerSelector;
import org.apache.pinot.client.ExternalViewReader;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DynamicBrokerSelectorTest {
    @Mock
    private ExternalViewReader _mockExternalViewReader;
    @Mock
    private ZkClient _mockZkClient;
    private DynamicBrokerSelector _dynamicBrokerSelectorUnderTest;
    private static final String ZK_SERVER = "zkServers";

    @BeforeMethod
    public void setUp() throws Exception {
        MockitoAnnotations.openMocks((Object)this);
        HashMap<String, List<String>> tableToBrokerListMap = new HashMap<String, List<String>>();
        tableToBrokerListMap.put("table1", Collections.singletonList("broker1"));
        Mockito.when((Object)this._mockExternalViewReader.getTableToBrokersMap()).thenReturn(tableToBrokerListMap);
        this._dynamicBrokerSelectorUnderTest = (DynamicBrokerSelector)Mockito.spy((Object)new DynamicBrokerSelector(ZK_SERVER){

            protected ExternalViewReader getEvReader(ZkClient zkClient) {
                return DynamicBrokerSelectorTest.this._mockExternalViewReader;
            }

            protected ExternalViewReader getEvReader(ZkClient zkClient, boolean preferTlsPort) {
                return DynamicBrokerSelectorTest.this._mockExternalViewReader;
            }

            protected ZkClient getZkClient(String zkServers) {
                return DynamicBrokerSelectorTest.this._mockZkClient;
            }
        });
    }

    @Test
    public void testHandleDataChange() {
        this._dynamicBrokerSelectorUnderTest.handleDataChange("dataPath", (Object)"data");
        ((ExternalViewReader)Mockito.verify((Object)this._mockExternalViewReader, (VerificationMode)Mockito.times((int)2))).getTableToBrokersMap();
    }

    @Test
    public void testHandleDataDeleted() {
        this._dynamicBrokerSelectorUnderTest.handleDataDeleted("dataPath");
        ((ExternalViewReader)Mockito.verify((Object)this._mockExternalViewReader, (VerificationMode)Mockito.times((int)2))).getTableToBrokersMap();
    }

    @Test
    public void testSelectBrokerWithTableName() {
        this._dynamicBrokerSelectorUnderTest.handleDataChange("dataPath", (Object)"data");
        String result = this._dynamicBrokerSelectorUnderTest.selectBroker("table1");
        Assert.assertEquals((String)"broker1", (String)result);
    }

    @Test
    public void testSelectBrokerWithDBAndTableName() {
        this._dynamicBrokerSelectorUnderTest.handleDataChange("dataPath", (Object)"data");
        String result = this._dynamicBrokerSelectorUnderTest.selectBroker("db1.table1");
        Assert.assertEquals((String)"broker1", (String)result);
        HashMap<String, List<String>> tableToBrokerListMap = new HashMap<String, List<String>>();
        tableToBrokerListMap.put("table1", Collections.singletonList("broker1"));
        tableToBrokerListMap.put("db1.table1", Collections.singletonList("broker2"));
        Mockito.when((Object)this._mockExternalViewReader.getTableToBrokersMap()).thenReturn(tableToBrokerListMap);
        this._dynamicBrokerSelectorUnderTest.handleDataChange("dataPath", (Object)"data");
        result = this._dynamicBrokerSelectorUnderTest.selectBroker("db1.table1");
        Assert.assertEquals((String)"broker2", (String)result);
    }

    @Test
    public void testSelectBrokerForNullTable() {
        this._dynamicBrokerSelectorUnderTest.handleDataChange("dataPath", (Object)"data");
        String result = this._dynamicBrokerSelectorUnderTest.selectBroker(null);
        Assert.assertEquals((String)"broker1", (String)result);
    }

    @Test
    public void testSelectBrokerForNullTableAndEmptyBrokerListRef() {
        Mockito.when((Object)this._mockExternalViewReader.getTableToBrokersMap()).thenReturn(Collections.emptyMap());
        this._dynamicBrokerSelectorUnderTest.handleDataChange("dummy-data-path", (Object)"dummy-date");
        String result = this._dynamicBrokerSelectorUnderTest.selectBroker(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testSelectBrokerForNonNullTableAndEmptyBrokerListRef() {
        Mockito.when((Object)this._mockExternalViewReader.getTableToBrokersMap()).thenReturn(Collections.emptyMap());
        this._dynamicBrokerSelectorUnderTest.handleDataChange("dummy-data-path", (Object)"dummy-date");
        String result = this._dynamicBrokerSelectorUnderTest.selectBroker("dummyTableName");
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGetBrokers() {
        Assert.assertEquals((Collection)this._dynamicBrokerSelectorUnderTest.getBrokers(), (Collection)ImmutableList.of((Object)ZK_SERVER));
    }

    @Test
    public void testCloseZkClient() {
        this._dynamicBrokerSelectorUnderTest.close();
        ((ZkClient)Mockito.verify((Object)this._mockZkClient, (VerificationMode)Mockito.times((int)1))).close();
    }
}

