/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.I0Itec.zkclient.ZkClient;
import org.apache.pinot.client.Connection;
import org.apache.pinot.client.ConnectionFactory;
import org.apache.pinot.client.DynamicBrokerSelector;
import org.apache.pinot.client.ExternalViewReader;
import org.apache.pinot.client.JsonAsyncHttpPinotClientTransportFactory;
import org.apache.pinot.client.PinotClientTransport;
import org.apache.pinot.client.ResultSetGroup;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConnectionFactoryTest {
    @Test
    public void testZkConnection() {
        String givenZkServers = "127.0.0.1:1234";
        DynamicBrokerSelector dynamicBrokerSelector = (DynamicBrokerSelector)Mockito.spy((Object)new DynamicBrokerSelector("127.0.0.1:1234"){

            protected ZkClient getZkClient(String zkServers) {
                return (ZkClient)Mockito.mock(ZkClient.class);
            }

            protected ExternalViewReader getEvReader(ZkClient zkClient) {
                return (ExternalViewReader)Mockito.mock(ExternalViewReader.class);
            }
        });
        PinotClientTransport pinotClientTransport = (PinotClientTransport)Mockito.mock(PinotClientTransport.class);
        Connection connection = ConnectionFactory.fromZookeeper((DynamicBrokerSelector)dynamicBrokerSelector, (PinotClientTransport)pinotClientTransport);
        Assert.assertEquals((Collection)connection.getBrokerList(), (Collection)ImmutableList.of((Object)"127.0.0.1:1234"));
    }

    @Test
    public void testPropertiesConnection() {
        Properties properties = new Properties();
        properties.setProperty("brokerList", "127.0.0.1:1234,localhost:2345");
        Connection connection = ConnectionFactory.fromProperties((Properties)properties);
        Assert.assertEquals((Collection)connection.getBrokerList(), (Collection)ImmutableList.of((Object)"127.0.0.1:1234", (Object)"localhost:2345"));
    }

    @Test
    public void testBrokerList() {
        String broker1 = "127.0.0.1:1234";
        String broker2 = "localhost:2345";
        Connection connection = ConnectionFactory.fromHostList((String[])new String[]{broker1, broker2});
        ImmutableList brokers = ImmutableList.of((Object)broker1, (Object)broker2);
        Assert.assertEquals((Collection)connection.getBrokerList(), (Collection)brokers);
    }

    @Test
    public void testBrokerListWithHeaders() {
        ImmutableList brokers = ImmutableList.of((Object)"127.0.0.1:1234", (Object)"localhost:2345");
        ImmutableMap headers = ImmutableMap.of((Object)"Caller", (Object)"curl");
        JsonAsyncHttpPinotClientTransportFactory factory = new JsonAsyncHttpPinotClientTransportFactory();
        factory.setHeaders((Map)headers);
        Connection connection = ConnectionFactory.fromHostList((List)brokers, (PinotClientTransport)factory.buildTransport());
        Assert.assertEquals((Collection)connection.getBrokerList(), (Collection)brokers);
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("USAGE ConnectionFactoryTest <ZK_URL> <tableName> <query>");
            System.exit(1);
        }
        String zkUrl = args[0];
        Connection connection = ConnectionFactory.fromZookeeper((String)zkUrl);
        String tableName = args[1];
        ResultSetGroup resultSetGroup = connection.execute(tableName, args[2]);
        System.out.println(resultSetGroup);
    }
}

