/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.client.AggregationResultSet;
import org.apache.pinot.spi.utils.JsonUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AggregationResultSetTest {
    private JsonNode _mockJsonObject;
    private AggregationResultSet _aggregationResultSetUnderTest;

    @BeforeMethod
    public void setUp() throws Exception {
        String jsonString = "{\"function\":\"testFunction\", \"value\":\"123\"}";
        this._mockJsonObject = JsonUtils.stringToJsonNode((String)jsonString);
        this._aggregationResultSetUnderTest = new AggregationResultSet(this._mockJsonObject);
    }

    @Test
    public void testGetRowCount() {
        int result = this._aggregationResultSetUnderTest.getRowCount();
        Assert.assertEquals((int)1, (int)result);
    }

    @Test
    public void testGetColumnCount() {
        int result = this._aggregationResultSetUnderTest.getColumnCount();
        Assert.assertEquals((int)1, (int)result);
    }

    @Test
    public void testGetColumnName() {
        String result = this._aggregationResultSetUnderTest.getColumnName(0);
        Assert.assertEquals((String)"testFunction", (String)result);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetStringForNonZeroRow() {
        this._aggregationResultSetUnderTest.getString(1, 0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testGetStringForNonZeroColumn() {
        this._aggregationResultSetUnderTest.getString(0, 1);
    }

    @Test
    public void testGetString() {
        String result = this._aggregationResultSetUnderTest.getString(0, 0);
        Assert.assertEquals((String)"123", (String)result);
    }

    @Test
    public void testGetGroupKeyLength() {
        int result = this._aggregationResultSetUnderTest.getGroupKeyLength();
        Assert.assertEquals((int)0, (int)result);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testGetGroupKeyColumnName() {
        this._aggregationResultSetUnderTest.getGroupKeyColumnName(0);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testGetGroupKeyString() {
        this._aggregationResultSetUnderTest.getGroupKeyString(0, 0);
    }

    @Test
    public void testToString() {
        String result = this._aggregationResultSetUnderTest.toString();
        Assert.assertNotEquals((Object)"", (Object)result);
    }
}

