/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.csv;

import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordExtractor;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordExtractorConfig;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.stream.StreamMessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVMessageDecoder
implements StreamMessageDecoder<byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVMessageDecoder.class);
    private static final String CONFIG_FILE_FORMAT = "fileFormat";
    private static final String CONFIG_HEADER = "header";
    private static final String CONFIG_DELIMITER = "delimiter";
    private static final String CONFIG_COMMENT_MARKER = "commentMarker";
    private static final String CONFIG_CSV_ESCAPE_CHARACTER = "escapeCharacter";
    private static final String CONFIG_CSV_MULTI_VALUE_DELIMITER = "multiValueDelimiter";
    public static final String NULL_STRING_VALUE = "nullStringValue";
    public static final String SKIP_HEADER = "skipHeader";
    public static final String IGNORE_EMPTY_LINES = "ignoreEmptyLines";
    public static final String IGNORE_SURROUNDING_SPACES = "ignoreSurroundingSpaces";
    public static final String QUOTE_CHARACTER = "quoteCharacter";
    public static final String QUOTE_MODE = "quoteMode";
    public static final String RECORD_SEPARATOR = "recordSeparator";
    private CSVFormat _format;
    private CSVRecordExtractor _recordExtractor;

    public void init(Map<String, String> props, Set<String> fieldsToRead, String topicName) throws Exception {
        String recordSeparator;
        String quoteMode;
        String quoteCharacter;
        String ignoreSurroundingSpaces;
        String ignoreEmptyLines;
        String skipHeader;
        String nullString;
        String escapeChar;
        String csvHeader;
        CSVFormat format;
        String csvFormat = props.get(CONFIG_FILE_FORMAT);
        if (csvFormat == null) {
            format = CSVFormat.DEFAULT;
        } else {
            switch (csvFormat.toUpperCase()) {
                case "EXCEL": {
                    format = CSVFormat.EXCEL;
                    break;
                }
                case "MYSQL": {
                    format = CSVFormat.MYSQL;
                    break;
                }
                case "RFC4180": {
                    format = CSVFormat.RFC4180;
                    break;
                }
                case "TDF": {
                    format = CSVFormat.TDF;
                    break;
                }
                case "DEFAULT": {
                    format = CSVFormat.DEFAULT;
                    break;
                }
                default: {
                    LOGGER.warn("Could not recognise the configured CSV file format: {}, falling back to DEFAULT format", (Object)csvFormat);
                    format = CSVFormat.DEFAULT;
                }
            }
        }
        String csvDelimiter = props.get(CONFIG_DELIMITER);
        if (csvDelimiter != null) {
            format = format.withDelimiter(csvDelimiter.charAt(0));
        }
        format = (csvHeader = props.get(CONFIG_HEADER)) == null ? format.withHeader(new String[0]) : format.withHeader(StringUtils.split((String)csvHeader, (String)csvDelimiter));
        String commentMarker = props.get(CONFIG_COMMENT_MARKER);
        if (commentMarker != null) {
            format = format.withCommentMarker(commentMarker.charAt(0));
        }
        if ((escapeChar = props.get(CONFIG_CSV_ESCAPE_CHARACTER)) != null) {
            format = format.withEscape(props.get(CONFIG_CSV_ESCAPE_CHARACTER).charAt(0));
        }
        if ((nullString = props.get(NULL_STRING_VALUE)) != null) {
            format = format.withNullString(nullString);
        }
        if ((skipHeader = props.get(SKIP_HEADER)) != null) {
            format = format.withSkipHeaderRecord(Boolean.parseBoolean(skipHeader));
        }
        if ((ignoreEmptyLines = props.get(IGNORE_EMPTY_LINES)) != null) {
            format = format.withIgnoreEmptyLines(Boolean.parseBoolean(ignoreEmptyLines));
        }
        if ((ignoreSurroundingSpaces = props.get(IGNORE_SURROUNDING_SPACES)) != null) {
            format = format.withIgnoreSurroundingSpaces(Boolean.parseBoolean(ignoreSurroundingSpaces));
        }
        if ((quoteCharacter = props.get(QUOTE_CHARACTER)) != null) {
            format = format.withQuote(quoteCharacter.charAt(0));
        }
        if ((quoteMode = props.get(QUOTE_MODE)) != null) {
            format = format.withQuoteMode(QuoteMode.valueOf((String)quoteMode));
        }
        if ((recordSeparator = props.get(RECORD_SEPARATOR)) != null) {
            format = format.withRecordSeparator(recordSeparator);
        }
        this._format = format;
        this._recordExtractor = new CSVRecordExtractor();
        CSVRecordExtractorConfig recordExtractorConfig = new CSVRecordExtractorConfig();
        String multiValueDelimiter = props.get(CONFIG_CSV_MULTI_VALUE_DELIMITER);
        if (multiValueDelimiter != null) {
            recordExtractorConfig.setMultiValueDelimiter(Character.valueOf(multiValueDelimiter.charAt(0)));
        }
        recordExtractorConfig.setColumnNames((Set<String>)ImmutableSet.copyOf((Object[])Objects.requireNonNull(this._format.getHeader())));
        this._recordExtractor.init(fieldsToRead, recordExtractorConfig);
    }

    public GenericRow decode(byte[] payload, GenericRow destination) {
        try {
            Iterator iterator = this._format.parse((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(payload), StandardCharsets.UTF_8)).iterator();
            return this._recordExtractor.extract((CSVRecord)iterator.next(), destination);
        }
        catch (IOException e) {
            throw new RuntimeException("Error decoding CSV record from payload", e);
        }
    }

    public GenericRow decode(byte[] payload, int offset, int length, GenericRow destination) {
        return this.decode(Arrays.copyOfRange(payload, offset, offset + length), destination);
    }
}

