/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.csv;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordReader;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordReaderConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.AbstractRecordReaderTest;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CSVRecordReaderTest
extends AbstractRecordReaderTest {
    private static final char CSV_MULTI_VALUE_DELIMITER = '\t';
    private static final CSVRecordReaderConfig[] NULL_AND_EMPTY_CONFIGS = new CSVRecordReaderConfig[]{null, new CSVRecordReaderConfig()};

    protected RecordReader createRecordReader(File file) throws Exception {
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setMultiValueDelimiter('\t');
        CSVRecordReader recordReader = new CSVRecordReader();
        recordReader.init(file, this._sourceFields, (RecordReaderConfig)readerConfig);
        return recordReader;
    }

    protected void writeRecordsToFile(List<Map<String, Object>> records) throws Exception {
        Schema schema = this.getPinotSchema();
        String[] columns = schema.getColumnNames().toArray(new String[0]);
        int numColumns = columns.length;
        try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)new FileWriter(this._dataFile), CSVFormat.Builder.create().setHeader(columns).build());){
            for (Map<String, Object> record : records) {
                Object[] values = new Object[numColumns];
                for (int i = 0; i < numColumns; ++i) {
                    values[i] = schema.getFieldSpecFor(columns[i]).isSingleValueField() ? record.get(columns[i]) : StringUtils.join((Object[])((List)record.get(columns[i])).toArray(), (char)'\t');
                }
                csvPrinter.printRecord(values);
            }
        }
    }

    protected String getDataFileName() {
        return "data.csv";
    }

    protected void checkValue(RecordReader recordReader, List<Map<String, Object>> expectedRecords, List<Object[]> expectedPrimaryKeys) throws Exception {
        int numRecords = expectedRecords.size();
        for (int i = 0; i < numRecords; ++i) {
            Map<String, Object> expectedRecord = expectedRecords.get(i);
            GenericRow actualRecord = recordReader.next();
            for (FieldSpec fieldSpec : this._pinotSchema.getAllFieldSpecs()) {
                int j;
                String column = fieldSpec.getName();
                if (fieldSpec.isSingleValueField()) {
                    Assert.assertEquals((String)actualRecord.getValue(column).toString(), (String)expectedRecord.get(column).toString());
                } else {
                    List expectedValues = (List)expectedRecord.get(column);
                    if (expectedValues.size() == 1) {
                        Assert.assertEquals((String)actualRecord.getValue(column).toString(), (String)expectedValues.get(0).toString());
                    } else {
                        Object[] actualValues = (Object[])actualRecord.getValue(column);
                        Assert.assertEquals((int)actualValues.length, (int)expectedValues.size());
                        for (j = 0; j < actualValues.length; ++j) {
                            Assert.assertEquals((String)actualValues[j].toString(), (String)expectedValues.get(j).toString());
                        }
                    }
                }
                Object[] expectedPrimaryKey = expectedPrimaryKeys.get(i);
                Object[] actualPrimaryKey = actualRecord.getPrimaryKey(this.getPrimaryKeyColumns()).getValues();
                for (j = 0; j < actualPrimaryKey.length; ++j) {
                    Assert.assertEquals((String)actualPrimaryKey[j].toString(), (String)expectedPrimaryKey[j].toString());
                }
            }
        }
        Assert.assertFalse((boolean)recordReader.hasNext());
    }

    @Test
    public void testInvalidDelimiterInHeader() throws IOException {
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setMultiValueDelimiter('\t');
        readerConfig.setHeader("col1;col2;col3;col4;col5;col6;col7;col8;col9;col10");
        try (CSVRecordReader recordReader = new CSVRecordReader();){
            Assert.assertThrows(IllegalStateException.class, () -> recordReader.init(this._dataFile, null, (RecordReaderConfig)readerConfig));
        }
    }

    @Test
    public void testValidDelimiterInHeader() throws IOException {
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setMultiValueDelimiter('\t');
        readerConfig.setHeader("col1,col2,col3,col4,col5,col6,col7,col8,col9,col10");
        try (CSVRecordReader recordReader = new CSVRecordReader();){
            recordReader.init(this._dataFile, null, (RecordReaderConfig)readerConfig);
            Assert.assertEquals((Collection)recordReader.getColumns(), List.of("col1", "col2", "col3", "col4", "col5", "col6", "col7", "col8", "col9", "col10"));
            Assert.assertTrue((boolean)recordReader.hasNext());
        }
    }

    @Test
    public void testReadingDataFileBasic() throws IOException {
        File dataFile = this.getDataFile("dataFileBasic.csv");
        for (CSVRecordReaderConfig readerConfig : NULL_AND_EMPTY_CONFIGS) {
            this.validate(dataFile, readerConfig, List.of(CSVRecordReaderTest.createMap("id", "100", "name", "John"), CSVRecordReaderTest.createMap("id", "101", "name", "Jane"), CSVRecordReaderTest.createMap("id", "102", "name", "Alice"), CSVRecordReaderTest.createMap("id", "103", "name", "Bob")));
        }
    }

    @Test
    public void testReadingDataFileWithSingleColumn() throws IOException {
        File dataFile = this.getDataFile("dataFileWithSingleColumn.csv");
        for (CSVRecordReaderConfig readerConfig : NULL_AND_EMPTY_CONFIGS) {
            this.validate(dataFile, readerConfig, List.of(CSVRecordReaderTest.createMap("name", "John"), CSVRecordReaderTest.createMap("name", "Jane"), CSVRecordReaderTest.createMap("name", "Jen")));
        }
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setHeader("firstName,lastName,id");
        readerConfig.setSkipHeader(true);
        this.validate(dataFile, readerConfig, List.of(CSVRecordReaderTest.createMap("firstName", "John", "lastName", null, "id", null), CSVRecordReaderTest.createMap("firstName", "Jane", "lastName", null, "id", null), CSVRecordReaderTest.createMap("firstName", "Jen", "lastName", null, "id", null)));
    }

    @Test
    public void testReadingDataFileWithInvalidHeader() throws IOException {
        File dataFile = this.getDataFile("dataFileWithInvalidHeader.csv");
        for (CSVRecordReaderConfig readerConfig : NULL_AND_EMPTY_CONFIGS) {
            try (CSVRecordReader recordReader = new CSVRecordReader();){
                Assert.assertThrows(IllegalStateException.class, () -> recordReader.init(dataFile, null, (RecordReaderConfig)readerConfig));
            }
        }
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setHeader("firstName,lastName,id");
        readerConfig.setSkipHeader(true);
        this.validate(dataFile, readerConfig, List.of(CSVRecordReaderTest.createMap("firstName", "John", "lastName", "Doe", "id", "100"), CSVRecordReaderTest.createMap("firstName", "Jane", "lastName", "Doe", "id", "101"), CSVRecordReaderTest.createMap("firstName", "Jen", "lastName", "Doe", "id", "102")));
    }

    @Test
    public void testReadingDataFileWithAlternateDelimiter() throws IOException {
        File dataFile = this.getDataFile("dataFileWithAlternateDelimiter.csv");
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setDelimiter('|');
        this.validate(dataFile, readerConfig, List.of(CSVRecordReaderTest.createMap("id", "100", "firstName", "John", "lastName", "Doe"), CSVRecordReaderTest.createMap("id", "101", "firstName", "Jane", "lastName", "Doe"), CSVRecordReaderTest.createMap("id", "102", "firstName", "Jen", "lastName", "Doe")));
    }

    @Test
    public void testReadingDataFileWithSurroundingSpaces() throws IOException {
        File dataFile = this.getDataFile("dataFileWithSurroundingSpaces.csv");
        for (CSVRecordReaderConfig readerConfig : NULL_AND_EMPTY_CONFIGS) {
            this.validate(dataFile, readerConfig, List.of(CSVRecordReaderTest.createMap("firstName", "John", "lastName", "Doe", "id", "100"), CSVRecordReaderTest.createMap("firstName", "Jane", "lastName", "Doe", "id", "101"), CSVRecordReaderTest.createMap("firstName", "Jen", "lastName", "Doe", "id", "102")));
        }
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setIgnoreSurroundingSpaces(false);
        this.validate(dataFile, readerConfig, List.of(CSVRecordReaderTest.createMap(" firstName ", "John  ", " lastName ", " Doe", " id", "100"), CSVRecordReaderTest.createMap(" firstName ", "Jane", " lastName ", " Doe", " id", "  101"), CSVRecordReaderTest.createMap(" firstName ", "Jen", " lastName ", "Doe ", " id", "102")));
    }

    @Test
    public void testReadingDataFileWithQuotes() throws IOException {
        File dataFile = this.getDataFile("dataFileWithQuotes.csv");
        for (CSVRecordReaderConfig readerConfig : NULL_AND_EMPTY_CONFIGS) {
            this.validate(dataFile, readerConfig, List.of(CSVRecordReaderTest.createMap("key", "key00", "num0", "12.3", "num1", "8.42"), CSVRecordReaderTest.createMap("key", "key01", "num0", null, "num1", "7.1"), CSVRecordReaderTest.createMap("key", "key02", "num0", null, "num1", "16.81"), CSVRecordReaderTest.createMap("key", "key03", "num0", null, "num1", "7.12")));
        }
    }

    @Test
    public void testReadingDataFileWithCustomNull() throws IOException {
        File dataFile = this.getDataFile("dataFileWithCustomNull.csv");
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setNullStringValue("NULL");
        this.validate(dataFile, readerConfig, List.of(CSVRecordReaderTest.createMap("id", "100", "name", null), CSVRecordReaderTest.createMap("id", null, "name", "Jane"), CSVRecordReaderTest.createMap("id", null, "name", null), CSVRecordReaderTest.createMap("id", null, "name", null)));
    }

    @Test
    public void testReadingDataFileWithCommentedLines() throws IOException {
        File dataFile = this.getDataFile("dataFileWithCommentedLines.csv");
        for (CSVRecordReaderConfig readerConfig : NULL_AND_EMPTY_CONFIGS) {
            this.validate(dataFile, readerConfig, 5, List.of(CSVRecordReaderTest.createMap("id", "# ignore line#1", "name", null)));
        }
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setCommentMarker(Character.valueOf('#'));
        this.validate(dataFile, readerConfig, List.of(CSVRecordReaderTest.createMap("id", "100", "name", "Jane"), CSVRecordReaderTest.createMap("id", "101", "name", "John"), CSVRecordReaderTest.createMap("id", "102", "name", "Sam")));
    }

    @Test
    public void testReadingDataFileWithEmptyLines() throws IOException {
        File dataFile = this.getDataFile("dataFileWithEmptyLines.csv");
        for (CSVRecordReaderConfig readerConfig : NULL_AND_EMPTY_CONFIGS) {
            this.validate(dataFile, readerConfig, 5);
        }
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setIgnoreEmptyLines(false);
        this.validate(dataFile, readerConfig, 8);
    }

    @Test
    public void testReadingDataFileWithEscapedQuotes() throws IOException {
        File dataFile = this.getDataFile("dataFileWithEscapedQuotes.csv");
        for (CSVRecordReaderConfig readerConfig : NULL_AND_EMPTY_CONFIGS) {
            this.validate(dataFile, readerConfig, List.of(CSVRecordReaderTest.createMap("\\\"id\\\"", "\\\"100\\\"", "\\\"name\\\"", "\\\"Jane\\\""), CSVRecordReaderTest.createMap("\\\"id\\\"", "\\\"101\\\"", "\\\"name\\\"", "\\\"John\\\"")));
        }
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setEscapeCharacter(Character.valueOf('\\'));
        this.validate(dataFile, readerConfig, List.of(CSVRecordReaderTest.createMap("\"id\"", "\"100\"", "\"name\"", "\"Jane\""), CSVRecordReaderTest.createMap("\"id\"", "\"101\"", "\"name\"", "\"John\"")));
    }

    @Test
    public void testReadingDataFileWithNoHeader() throws IOException {
        File dataFile = this.getDataFile("dataFileWithNoHeader.csv");
        for (CSVRecordReaderConfig readerConfig : NULL_AND_EMPTY_CONFIGS) {
            this.validate(dataFile, readerConfig, List.of(CSVRecordReaderTest.createMap("100", "101", "Jane", "John"), CSVRecordReaderTest.createMap("100", "102", "Jane", "Sam")));
        }
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setHeader("id,name");
        this.validate(dataFile, readerConfig, List.of(CSVRecordReaderTest.createMap("id", "100", "name", "Jane"), CSVRecordReaderTest.createMap("id", "101", "name", "John"), CSVRecordReaderTest.createMap("id", "102", "name", "Sam")));
    }

    @Test
    public void testReadingDataFileWithNoHeaderAndEmptyValues() throws IOException {
        File dataFile = this.getDataFile("dataFileWithNoHeaderAndEmptyValues.csv");
        for (CSVRecordReaderConfig readerConfig : NULL_AND_EMPTY_CONFIGS) {
            this.validate(dataFile, readerConfig, List.of(CSVRecordReaderTest.createMap("key00", "key01", "12.3", null, "8.42", "7.1"), CSVRecordReaderTest.createMap("key00", "key02", "12.3", null, "8.42", "16.81"), CSVRecordReaderTest.createMap("key00", "key03", "12.3", null, "8.42", "7.12")));
        }
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setHeader("key,num0,num1");
        this.validate(dataFile, readerConfig, List.of(CSVRecordReaderTest.createMap("key", "key00", "num0", "12.3", "num1", "8.42"), CSVRecordReaderTest.createMap("key", "key01", "num0", null, "num1", "7.1"), CSVRecordReaderTest.createMap("key", "key02", "num0", null, "num1", "16.81"), CSVRecordReaderTest.createMap("key", "key03", "num0", null, "num1", "7.12")));
    }

    @Test
    public void testReadingDataFileWithNoRecords() throws IOException {
        File dataFile = this.getDataFile("dataFileWithNoRecords.csv");
        for (CSVRecordReaderConfig readerConfig : NULL_AND_EMPTY_CONFIGS) {
            this.validate(dataFile, readerConfig, 0);
        }
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setHeader("id,name");
        readerConfig.setSkipHeader(true);
        this.validate(dataFile, readerConfig, 0);
    }

    @Test
    public void testReadingDataFileEmpty() throws IOException {
        File dataFile = this.getDataFile("dataFileEmpty.csv");
        for (CSVRecordReaderConfig readerConfig : NULL_AND_EMPTY_CONFIGS) {
            this.validate(dataFile, readerConfig, 0);
        }
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setHeader("id,name");
        this.validate(dataFile, readerConfig, 0);
    }

    @Test
    public void testReadingDataFileWithMultiLineValues() throws IOException {
        File dataFile = this.getDataFile("dataFileWithMultiLineValues.csv");
        for (CSVRecordReaderConfig readerConfig : NULL_AND_EMPTY_CONFIGS) {
            this.validate(dataFile, readerConfig, List.of(CSVRecordReaderTest.createMap("id", "100", "name", "John\n101,Jane"), CSVRecordReaderTest.createMap("id", "102", "name", "Alice")));
        }
    }

    @Test
    public void testReadingDataFileWithUnparseableFirstLine() throws IOException {
        File dataFile = this.getDataFile("dataFileWithUnparseableFirstLine.csv");
        for (CSVRecordReaderConfig readerConfig : NULL_AND_EMPTY_CONFIGS) {
            try (CSVRecordReader recordReader = new CSVRecordReader();){
                Assert.assertThrows(IOException.class, () -> recordReader.init(dataFile, null, (RecordReaderConfig)readerConfig));
            }
        }
    }

    @Test
    public void testLineIteratorReadingDataFileWithUnparseableLine() throws IOException {
        File dataFile = this.getDataFile("dataFileWithUnparseableLine.csv");
        for (CSVRecordReaderConfig readerConfig : NULL_AND_EMPTY_CONFIGS) {
            try (CSVRecordReader recordReader = new CSVRecordReader();){
                recordReader.init(dataFile, null, (RecordReaderConfig)readerConfig);
                this.testUnparseableLine(recordReader);
                recordReader.rewind();
                this.testUnparseableLine(recordReader);
            }
        }
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setStopOnError(true);
        try (CSVRecordReader recordReader = new CSVRecordReader();){
            recordReader.init(dataFile, null, (RecordReaderConfig)readerConfig);
            this.testUnparseableLineStopOnError(recordReader);
            recordReader.rewind();
            this.testUnparseableLineStopOnError(recordReader);
        }
    }

    private void testUnparseableLine(CSVRecordReader recordReader) throws IOException {
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "100", "name", "John"));
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertThrows(UncheckedIOException.class, () -> ((CSVRecordReader)recordReader).next());
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "102", "name", "Alice"));
        Assert.assertFalse((boolean)recordReader.hasNext());
    }

    private void testUnparseableLineStopOnError(CSVRecordReader recordReader) throws IOException {
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "100", "name", "John"));
        Assert.assertFalse((boolean)recordReader.hasNext());
    }

    @Test
    public void testLineIteratorReadingDataFileWithUnparseableLastLine() throws IOException {
        File dataFile = this.getDataFile("dataFileWithUnparseableLastLine.csv");
        for (CSVRecordReaderConfig readerConfig : NULL_AND_EMPTY_CONFIGS) {
            try (CSVRecordReader recordReader = new CSVRecordReader();){
                recordReader.init(dataFile, null, (RecordReaderConfig)readerConfig);
                this.testUnparseableLastLine(recordReader);
                recordReader.rewind();
                this.testUnparseableLastLine(recordReader);
            }
        }
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setStopOnError(true);
        try (CSVRecordReader recordReader = new CSVRecordReader();){
            recordReader.init(dataFile, null, (RecordReaderConfig)readerConfig);
            this.testUnparseableLastLineStopOnError(recordReader);
            recordReader.rewind();
            this.testUnparseableLastLineStopOnError(recordReader);
        }
    }

    private void testUnparseableLastLine(CSVRecordReader recordReader) throws IOException {
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "100", "name", "John"));
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertThrows(UncheckedIOException.class, () -> ((CSVRecordReader)recordReader).next());
        Assert.assertFalse((boolean)recordReader.hasNext());
    }

    private void testUnparseableLastLineStopOnError(CSVRecordReader recordReader) throws IOException {
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "100", "name", "John"));
        Assert.assertFalse((boolean)recordReader.hasNext());
    }

    @Test
    public void testReadingDataFileWithPartialLastRow() throws IOException {
        File dataFile = this.getDataFile("dataFileWithPartialLastRow.csv");
        for (CSVRecordReaderConfig readerConfig : NULL_AND_EMPTY_CONFIGS) {
            try (CSVRecordReader recordReader = new CSVRecordReader();){
                recordReader.init(dataFile, null, (RecordReaderConfig)readerConfig);
                this.testPartialLastRow(recordReader);
                recordReader.rewind();
                this.testPartialLastRow(recordReader);
            }
        }
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setStopOnError(true);
        try (CSVRecordReader recordReader = new CSVRecordReader();){
            recordReader.init(dataFile, null, (RecordReaderConfig)readerConfig);
            this.testPartialLastRowStopOnError(recordReader);
            recordReader.rewind();
            this.testPartialLastRowStopOnError(recordReader);
        }
    }

    private void testPartialLastRow(CSVRecordReader recordReader) throws IOException {
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "100", "firstName", "jane", "lastName", "doe", "appVersion", "1.0.0", "active", "yes"));
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "101", "firstName", "john", "lastName", "doe", "appVersion", "1.0.1", "active", "yes"));
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertThrows(UncheckedIOException.class, () -> ((CSVRecordReader)recordReader).next());
        Assert.assertFalse((boolean)recordReader.hasNext());
    }

    private void testPartialLastRowStopOnError(CSVRecordReader recordReader) throws IOException {
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "100", "firstName", "jane", "lastName", "doe", "appVersion", "1.0.0", "active", "yes"));
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "101", "firstName", "john", "lastName", "doe", "appVersion", "1.0.1", "active", "yes"));
        Assert.assertFalse((boolean)recordReader.hasNext());
    }

    @Test
    public void testLineIteratorReadingDataFileWithMultipleCombinations() throws IOException {
        File dataFile = this.getDataFile("dataFileWithMultipleCombinations.csv");
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setCommentMarker(Character.valueOf('#'));
        readerConfig.setEscapeCharacter(Character.valueOf('\\'));
        try (CSVRecordReader recordReader = new CSVRecordReader();){
            recordReader.init(dataFile, null, (RecordReaderConfig)readerConfig);
            this.testCombinations(recordReader);
            recordReader.rewind();
            this.testCombinations(recordReader);
        }
        readerConfig.setStopOnError(true);
        recordReader = new CSVRecordReader();
        try {
            recordReader.init(dataFile, null, (RecordReaderConfig)readerConfig);
            this.testCombinationsStopOnError(recordReader);
            recordReader.rewind();
            this.testCombinationsStopOnError(recordReader);
        }
        finally {
            recordReader.close();
        }
    }

    private void testCombinations(CSVRecordReader recordReader) throws IOException {
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "100", "name", "John"));
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "101", "name", "Jane"));
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "102", "name", "Jerry"));
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "103", "name", "Suzanne"));
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertThrows(UncheckedIOException.class, () -> ((CSVRecordReader)recordReader).next());
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertThrows(UncheckedIOException.class, () -> ((CSVRecordReader)recordReader).next());
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "105", "name", "Zack\nZack"));
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "\"106\"", "name", "\"Ze\""));
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "107", "name", "Zu"));
        Assert.assertFalse((boolean)recordReader.hasNext());
    }

    private void testCombinationsStopOnError(CSVRecordReader recordReader) throws IOException {
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "100", "name", "John"));
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "101", "name", "Jane"));
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "102", "name", "Jerry"));
        Assert.assertTrue((boolean)recordReader.hasNext());
        Assert.assertEquals((Map)recordReader.next().getFieldToValueMap(), CSVRecordReaderTest.createMap("id", "103", "name", "Suzanne"));
        Assert.assertFalse((boolean)recordReader.hasNext());
    }

    private File getDataFile(String fileName) {
        return new File(ClassLoader.getSystemResource(fileName).getFile());
    }

    private void validate(File dataFile, @Nullable CSVRecordReaderConfig readerConfig, int expectedNumRows, @Nullable List<Map<String, Object>> expectedRows) throws IOException {
        GenericRow genericRow;
        ArrayList<GenericRow> genericRows = new ArrayList<GenericRow>(expectedNumRows);
        try (CSVRecordReader recordReader = new CSVRecordReader();){
            recordReader.init(dataFile, null, (RecordReaderConfig)readerConfig);
            while (recordReader.hasNext()) {
                genericRows.add(recordReader.next());
            }
            Assert.assertEquals((int)genericRows.size(), (int)expectedNumRows);
            recordReader.rewind();
            for (GenericRow genericRow2 : genericRows) {
                genericRow = recordReader.next();
                Assert.assertEquals((Object)genericRow, (Object)genericRow2);
            }
            Assert.assertFalse((boolean)recordReader.hasNext());
        }
        if (expectedRows != null) {
            int rowId = 0;
            for (Map map : expectedRows) {
                genericRow = (GenericRow)genericRows.get(rowId++);
                Assert.assertEquals((Map)genericRow.getFieldToValueMap(), (Map)map);
            }
        }
    }

    private void validate(File dataFile, @Nullable CSVRecordReaderConfig readerConfig, int expectedNumRows) throws IOException {
        this.validate(dataFile, readerConfig, expectedNumRows, null);
    }

    private void validate(File dataFile, @Nullable CSVRecordReaderConfig readerConfig, List<Map<String, Object>> expectedRows) throws IOException {
        this.validate(dataFile, readerConfig, expectedRows.size(), expectedRows);
    }

    private static Map<String, Object> createMap(String ... keyValues) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < keyValues.length; i += 2) {
            map.put(keyValues[i], keyValues[i + 1]);
        }
        return map;
    }
}

