/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.csv;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordReader;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordReaderConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.AbstractRecordReaderTest;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CSVRecordReaderTest
extends AbstractRecordReaderTest {
    private static final char CSV_MULTI_VALUE_DELIMITER = '\t';

    protected RecordReader createRecordReader(File file) throws Exception {
        CSVRecordReaderConfig csvRecordReaderConfig = new CSVRecordReaderConfig();
        csvRecordReaderConfig.setMultiValueDelimiter('\t');
        CSVRecordReader csvRecordReader = new CSVRecordReader();
        csvRecordReader.init(file, this._sourceFields, (RecordReaderConfig)csvRecordReaderConfig);
        return csvRecordReader;
    }

    protected void writeRecordsToFile(List<Map<String, Object>> recordsToWrite) throws Exception {
        Schema pinotSchema = this.getPinotSchema();
        String[] columns = pinotSchema.getColumnNames().toArray(new String[0]);
        try (FileWriter fileWriter = new FileWriter(this._dataFile);
             CSVPrinter csvPrinter = new CSVPrinter((Appendable)fileWriter, CSVFormat.DEFAULT.withHeader(columns));){
            for (Map<String, Object> r : recordsToWrite) {
                Object[] record = new Object[columns.length];
                for (int i = 0; i < columns.length; ++i) {
                    record[i] = pinotSchema.getFieldSpecFor(columns[i]).isSingleValueField() ? r.get(columns[i]) : StringUtils.join((Object[])((List)r.get(columns[i])).toArray(), (char)'\t');
                }
                csvPrinter.printRecord(record);
            }
        }
    }

    protected String getDataFileName() {
        return "data.csv";
    }

    protected void checkValue(RecordReader recordReader, List<Map<String, Object>> expectedRecordsMap, List<Object[]> expectedPrimaryKeys) throws Exception {
        for (int i = 0; i < expectedRecordsMap.size(); ++i) {
            Map<String, Object> expectedRecord = expectedRecordsMap.get(i);
            GenericRow actualRecord = recordReader.next();
            for (FieldSpec fieldSpec : this._pinotSchema.getAllFieldSpecs()) {
                String fieldSpecName = fieldSpec.getName();
                if (fieldSpec.isSingleValueField()) {
                    Assert.assertEquals((String)actualRecord.getValue(fieldSpecName).toString(), (String)expectedRecord.get(fieldSpecName).toString());
                } else {
                    List expectedRecords = (List)expectedRecord.get(fieldSpecName);
                    if (expectedRecords.size() == 1) {
                        Assert.assertEquals((String)actualRecord.getValue(fieldSpecName).toString(), (String)expectedRecords.get(0).toString());
                    } else {
                        Object[] actualRecords = (Object[])actualRecord.getValue(fieldSpecName);
                        Assert.assertEquals((int)actualRecords.length, (int)expectedRecords.size());
                        for (int j = 0; j < actualRecords.length; ++j) {
                            Assert.assertEquals((String)actualRecords[j].toString(), (String)expectedRecords.get(j).toString());
                        }
                    }
                }
                PrimaryKey primaryKey = actualRecord.getPrimaryKey(this.getPrimaryKeyColumns());
                for (int j = 0; j < primaryKey.getValues().length; ++j) {
                    Assert.assertEquals((String)primaryKey.getValues()[j].toString(), (String)expectedPrimaryKeys.get(i)[j].toString());
                }
            }
        }
        Assert.assertFalse((boolean)recordReader.hasNext());
    }

    @Test
    public void testInvalidDelimiterInHeader() {
        CSVRecordReaderConfig csvRecordReaderConfig = new CSVRecordReaderConfig();
        csvRecordReaderConfig.setMultiValueDelimiter('\t');
        csvRecordReaderConfig.setHeader("col1;col2;col3;col4;col5;col6;col7;col8;col9;col10");
        csvRecordReaderConfig.setDelimiter(',');
        CSVRecordReader csvRecordReader = new CSVRecordReader();
        Assert.assertThrows(IllegalArgumentException.class, () -> csvRecordReader.init(this._dataFile, null, (RecordReaderConfig)csvRecordReaderConfig));
    }

    @Test
    public void testValidDelimiterInHeader() throws IOException {
        CSVRecordReaderConfig csvRecordReaderConfig = new CSVRecordReaderConfig();
        csvRecordReaderConfig.setMultiValueDelimiter('\t');
        csvRecordReaderConfig.setHeader("col1,col2,col3,col4,col5,col6,col7,col8,col9,col10");
        csvRecordReaderConfig.setDelimiter(',');
        CSVRecordReader csvRecordReader = new CSVRecordReader();
        csvRecordReader.init(this._dataFile, null, (RecordReaderConfig)csvRecordReaderConfig);
        Assert.assertEquals((int)10, (int)csvRecordReader.getCSVHeaderMap().size());
        Assert.assertTrue((boolean)csvRecordReader.getCSVHeaderMap().containsKey("col1"));
        Assert.assertTrue((boolean)csvRecordReader.hasNext());
    }

    @Test
    public void testHeaderDelimiterSingleColumn() throws IOException {
        Schema pinotSchema = this.getPinotSchema();
        String column = pinotSchema.getColumnNames().toArray(new String[0])[0];
        File file = new File(this._tempDir, "data1.csv");
        try (FileWriter fileWriter = new FileWriter(file);
             CSVPrinter csvPrinter = new CSVPrinter((Appendable)fileWriter, CSVFormat.DEFAULT.withHeader(new String[]{column}));){
            for (Map r : this._records) {
                Object[] record = new Object[]{r.get(column)};
                csvPrinter.printRecord(record);
            }
        }
        CSVRecordReaderConfig csvRecordReaderConfig = new CSVRecordReaderConfig();
        csvRecordReaderConfig.setMultiValueDelimiter('\t');
        csvRecordReaderConfig.setHeader("col1");
        CSVRecordReader csvRecordReader = new CSVRecordReader();
        csvRecordReader.init(file, null, (RecordReaderConfig)csvRecordReaderConfig);
        Assert.assertTrue((boolean)csvRecordReader.hasNext());
    }

    @Test
    public void testNullValueString() throws IOException {
        String nullString = "NULL";
        Schema pinotSchema = this.getPinotSchema();
        String column = pinotSchema.getColumnNames().toArray(new String[0])[0];
        File file = new File(this._tempDir, "data1.csv");
        try (FileWriter fileWriter = new FileWriter(file);
             CSVPrinter csvPrinter = new CSVPrinter((Appendable)fileWriter, CSVFormat.DEFAULT.withHeader(new String[]{"col1", "col2", "col3"}).withNullString(nullString));){
            for (Map r : this._records) {
                Object[] record = new Object[3];
                record[0] = r.get(column);
                csvPrinter.printRecord(record);
            }
        }
        CSVRecordReaderConfig csvRecordReaderConfig = new CSVRecordReaderConfig();
        csvRecordReaderConfig.setMultiValueDelimiter('\t');
        csvRecordReaderConfig.setHeader("col1,col2,col3");
        csvRecordReaderConfig.setNullStringValue(nullString);
        CSVRecordReader csvRecordReader = new CSVRecordReader();
        csvRecordReader.init(file, null, (RecordReaderConfig)csvRecordReaderConfig);
        Assert.assertTrue((boolean)csvRecordReader.hasNext());
        csvRecordReader.next();
        GenericRow row = csvRecordReader.next();
        Assert.assertNotNull((Object)row.getValue("col1"));
        Assert.assertNull((Object)row.getValue("col2"));
        Assert.assertNull((Object)row.getValue("col3"));
    }

    @Test
    public void testReadingDataFileWithCommentedLines() throws IOException, URISyntaxException {
        URI uri = ClassLoader.getSystemResource("dataFileWithCommentedLines.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setSkipUnParseableLines(true);
        readerConfig.setCommentMarker(Character.valueOf('#'));
        List<GenericRow> genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)3, (int)genericRows.size());
        readerConfig.setSkipUnParseableLines(false);
        genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)3, (int)genericRows.size());
    }

    @Test
    public void testReadingDataFileWithEmptyLines() throws URISyntaxException, IOException {
        URI uri = ClassLoader.getSystemResource("dataFileWithEmptyLines.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setSkipUnParseableLines(true);
        List<GenericRow> genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)5, (int)genericRows.size());
        readerConfig.setSkipUnParseableLines(false);
        genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)5, (int)genericRows.size());
    }

    @Test
    public void testReadingDataFileWithEscapedQuotes() throws URISyntaxException, IOException {
        URI uri = ClassLoader.getSystemResource("dataFileWithEscapedQuotes.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setSkipUnParseableLines(true);
        List<GenericRow> genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)2, (int)genericRows.size());
        readerConfig.setSkipUnParseableLines(false);
        genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)2, (int)genericRows.size());
    }

    @Test
    public void testReadingDataFileWithNoHeader() throws URISyntaxException, IOException {
        URI uri = ClassLoader.getSystemResource("dataFileWithNoHeader.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setSkipUnParseableLines(true);
        readerConfig.setHeader("id,name");
        List<GenericRow> genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)3, (int)genericRows.size());
        readerConfig.setSkipUnParseableLines(false);
        genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)3, (int)genericRows.size());
    }

    @Test
    public void testReadingDataFileWithQuotedHeaders() throws URISyntaxException, IOException {
        URI uri = ClassLoader.getSystemResource("dataFileWithQuotedHeaders.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setSkipUnParseableLines(true);
        List<GenericRow> genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)2, (int)genericRows.size());
        readerConfig.setSkipUnParseableLines(false);
        genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)2, (int)genericRows.size());
    }

    @Test
    public void testLineIteratorReadingDataFileWithUnparseableLines() throws URISyntaxException, IOException {
        URI uri = ClassLoader.getSystemResource("dataFileWithUnparseableLines.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setSkipUnParseableLines(true);
        List<GenericRow> genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)1, (int)genericRows.size());
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testDefaultCsvReaderExceptionReadingDataFileWithUnparseableLines() throws URISyntaxException, IOException {
        URI uri = ClassLoader.getSystemResource("dataFileWithUnparseableLines.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        this.readCSVRecords(dataFile, readerConfig, null, false);
    }

    @Test
    public void testLineIteratorReadingDataFileWithMultipleCombinations() throws URISyntaxException, IOException {
        URI uri = ClassLoader.getSystemResource("dataFileWithMultipleCombinations.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setSkipUnParseableLines(true);
        readerConfig.setCommentMarker(Character.valueOf('#'));
        readerConfig.setIgnoreEmptyLines(true);
        List<GenericRow> genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)7, (int)genericRows.size());
    }

    @Test
    public void testDefaultCsvReaderReadingDataFileWithMultipleCombinations() throws URISyntaxException, IOException {
        URI uri = ClassLoader.getSystemResource("dataFileWithMultipleCombinationsParseable.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setCommentMarker(Character.valueOf('#'));
        readerConfig.setIgnoreEmptyLines(true);
        List<GenericRow> genericRows = this.readCSVRecords(dataFile, readerConfig, new GenericRow(), false);
        Assert.assertEquals((int)7, (int)genericRows.size());
    }

    @Test
    public void testLineIteratorRewindMethod() throws URISyntaxException, IOException {
        URI uri = ClassLoader.getSystemResource("dataFileWithMultipleCombinations.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setSkipUnParseableLines(true);
        readerConfig.setCommentMarker(Character.valueOf('#'));
        readerConfig.setIgnoreEmptyLines(true);
        this.readCSVRecords(dataFile, readerConfig, null, true);
        List<GenericRow> genericRows = this.readCSVRecords(dataFile, readerConfig, new GenericRow(), false);
        Assert.assertEquals((int)7, (int)genericRows.size());
    }

    @Test
    public void testDefaultCsvReaderRewindMethod() throws URISyntaxException, IOException {
        URI uri = ClassLoader.getSystemResource("dataFileWithMultipleCombinationsParseable.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setCommentMarker(Character.valueOf('#'));
        readerConfig.setIgnoreEmptyLines(true);
        this.readCSVRecords(dataFile, readerConfig, null, true);
        List<GenericRow> genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)7, (int)genericRows.size());
    }

    @Test
    public void testReadingDataFileWithInvalidHeader() throws URISyntaxException, IOException {
        URI uri = ClassLoader.getSystemResource("dataFileWithInvalidHeader.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setHeader("firstName,lastName,id");
        readerConfig.setSkipHeader(true);
        readerConfig.setSkipUnParseableLines(true);
        List<GenericRow> genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)3, (int)genericRows.size());
        readerConfig.setSkipUnParseableLines(false);
        genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)3, (int)genericRows.size());
    }

    @Test
    public void testReadingDataFileWithAlternateDelimiter() throws URISyntaxException, IOException {
        URI uri = ClassLoader.getSystemResource("dataFileWithAlternateDelimiter.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setDelimiter('|');
        readerConfig.setSkipUnParseableLines(true);
        List<GenericRow> genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)3, (int)genericRows.size());
        readerConfig.setSkipUnParseableLines(false);
        genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)3, (int)genericRows.size());
    }

    @Test
    public void testReadingDataFileWithSpaceAroundHeaderFields() throws URISyntaxException, IOException {
        URI uri = ClassLoader.getSystemResource("dataFileWithSpaceAroundHeaders.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setSkipUnParseableLines(true);
        readerConfig.setIgnoreSurroundingSpaces(true);
        List<GenericRow> genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)3, (int)genericRows.size());
        this.validateSpaceAroundHeadersAreTrimmed(dataFile, readerConfig);
        readerConfig.setSkipUnParseableLines(false);
        genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)3, (int)genericRows.size());
        this.validateSpaceAroundHeadersAreTrimmed(dataFile, readerConfig);
    }

    @Test
    public void testReadingDataFileWithSpaceAroundHeaderAreRetained() throws URISyntaxException, IOException {
        URI uri = ClassLoader.getSystemResource("dataFileWithSpaceAroundHeaders.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setSkipUnParseableLines(true);
        readerConfig.setIgnoreSurroundingSpaces(false);
        List<GenericRow> genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)3, (int)genericRows.size());
        this.validateSpaceAroundHeadersAreRetained(dataFile, readerConfig);
        readerConfig.setSkipUnParseableLines(false);
        genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)3, (int)genericRows.size());
        this.validateSpaceAroundHeadersAreRetained(dataFile, readerConfig);
    }

    @Test
    public void testRewindMethodAndSkipHeader() throws URISyntaxException, IOException {
        URI uri = ClassLoader.getSystemResource("dataFileWithInvalidHeader.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setSkipUnParseableLines(true);
        readerConfig.setHeader("id,name");
        readerConfig.setSkipHeader(true);
        this.readCSVRecords(dataFile, readerConfig, new GenericRow(), true);
        List<GenericRow> genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)3, (int)genericRows.size());
        readerConfig.setSkipUnParseableLines(false);
        this.readCSVRecords(dataFile, readerConfig, null, true);
        genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)3, (int)genericRows.size());
    }

    @Test
    public void testReadingDataFileWithPartialLastRow() throws URISyntaxException, IOException {
        URI uri = ClassLoader.getSystemResource("dataFileWithPartialLastRow.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setSkipUnParseableLines(true);
        List<GenericRow> genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)2, (int)genericRows.size());
    }

    @Test
    public void testReadingDataFileWithNoRecords() throws URISyntaxException, IOException {
        URI uri = ClassLoader.getSystemResource("dataFileWithNoRecords.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setSkipUnParseableLines(true);
        List<GenericRow> genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)0, (int)genericRows.size());
    }

    @Test
    public void testReadingDataFileWithNoHeaderAndDataRecordsWithEmptyValues() throws URISyntaxException, IOException {
        URI uri = ClassLoader.getSystemResource("dataFileWithNoHeader2.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setSkipUnParseableLines(true);
        readerConfig.setHeader("key,num0,num1");
        List<GenericRow> genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)4, (int)genericRows.size());
        readerConfig.setSkipUnParseableLines(false);
        genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)4, (int)genericRows.size());
    }

    @Test
    public void testReadingDataFileWithValidHeaders() throws URISyntaxException, IOException {
        URI uri = ClassLoader.getSystemResource("dataFileWithValidHeaders.csv").toURI();
        File dataFile = new File(uri);
        CSVRecordReaderConfig readerConfig = new CSVRecordReaderConfig();
        readerConfig.setSkipUnParseableLines(true);
        readerConfig.setSkipHeader(false);
        List<GenericRow> genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)4, (int)genericRows.size());
        readerConfig.setSkipUnParseableLines(false);
        genericRows = this.readCSVRecords(dataFile, readerConfig, null, false);
        Assert.assertEquals((int)4, (int)genericRows.size());
    }

    private List<GenericRow> readCSVRecords(File dataFile, CSVRecordReaderConfig readerConfig, GenericRow genericRow, boolean rewind) throws IOException {
        ArrayList<GenericRow> genericRows = new ArrayList<GenericRow>();
        try (CSVRecordReader recordReader = new CSVRecordReader();){
            recordReader.init(dataFile, null, (RecordReaderConfig)readerConfig);
            GenericRow reuse = new GenericRow();
            while (recordReader.hasNext()) {
                if (genericRow != null) {
                    recordReader.next(reuse);
                    genericRows.add(reuse);
                    continue;
                }
                GenericRow nextRow = recordReader.next();
                genericRows.add(nextRow);
            }
            if (rewind) {
                recordReader.rewind();
            }
        }
        return genericRows;
    }

    private void validateSpaceAroundHeadersAreTrimmed(File dataFile, CSVRecordReaderConfig readerConfig) throws IOException {
        try (CSVRecordReader recordReader = new CSVRecordReader();){
            recordReader.init(dataFile, null, (RecordReaderConfig)readerConfig);
            Map headerMap = recordReader.getCSVHeaderMap();
            Assert.assertEquals((int)3, (int)headerMap.size());
            List<String> headers = List.of("firstName", "lastName", "id");
            for (String header : headers) {
                Assert.assertTrue((boolean)headerMap.containsKey(header));
            }
        }
    }

    private void validateSpaceAroundHeadersAreRetained(File dataFile, CSVRecordReaderConfig readerConfig) throws IOException {
        try (CSVRecordReader recordReader = new CSVRecordReader();){
            recordReader.init(dataFile, null, (RecordReaderConfig)readerConfig);
            Map headerMap = recordReader.getCSVHeaderMap();
            Assert.assertEquals((int)3, (int)headerMap.size());
            List<String> headers = List.of(" firstName ", " lastName ", " id");
            for (String header : headers) {
                Assert.assertTrue((boolean)headerMap.containsKey(header));
            }
        }
    }
}

