/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordExtractor;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordExtractorConfig;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordReaderConfig;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.apache.pinot.spi.data.readers.RecordReaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class CSVRecordReader
implements RecordReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVRecordReader.class);
    private File _dataFile;
    private CSVFormat _format;
    private CSVParser _parser;
    private Iterator<CSVRecord> _iterator;
    private CSVRecordExtractor _recordExtractor;
    private Map<String, Integer> _headerMap = new HashMap<String, Integer>();
    private boolean _isHeaderProvided = false;
    private boolean _useLineIterator = false;
    private boolean _skipHeaderRecord = false;
    private long _skippedLinesCount;
    private BufferedReader _bufferedReader;
    private String _nextLine;
    private GenericRow _nextRecord;

    public void init(File dataFile, @Nullable Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) throws IOException {
        this._dataFile = dataFile;
        CSVRecordReaderConfig config = (CSVRecordReaderConfig)recordReaderConfig;
        Character multiValueDelimiter = null;
        if (config == null) {
            this._format = CSVFormat.DEFAULT.builder().setDelimiter(',').setHeader(new String[0]).build();
            multiValueDelimiter = Character.valueOf(';');
        } else {
            String nullString;
            CSVFormat format;
            String formatString = config.getFileFormat();
            if (formatString == null) {
                format = CSVFormat.DEFAULT;
            } else {
                switch (formatString.toUpperCase()) {
                    case "EXCEL": {
                        format = CSVFormat.EXCEL;
                        break;
                    }
                    case "MYSQL": {
                        format = CSVFormat.MYSQL;
                        break;
                    }
                    case "RFC4180": {
                        format = CSVFormat.RFC4180;
                        break;
                    }
                    case "TDF": {
                        format = CSVFormat.TDF;
                        break;
                    }
                    default: {
                        format = CSVFormat.DEFAULT;
                    }
                }
            }
            char delimiter = config.getDelimiter();
            format = format.builder().setDelimiter(delimiter).build();
            if (config.isSkipUnParseableLines()) {
                this._useLineIterator = true;
            }
            this._isHeaderProvided = config.getHeader() != null;
            this._skipHeaderRecord = config.isSkipHeader();
            this._format = format.builder().setHeader(new String[0]).setSkipHeaderRecord(config.isSkipHeader()).setCommentMarker(config.getCommentMarker()).setEscape(config.getEscapeCharacter()).setIgnoreEmptyLines(config.isIgnoreEmptyLines()).setIgnoreSurroundingSpaces(config.isIgnoreSurroundingSpaces()).setQuote(config.getQuoteCharacter()).build();
            if (config.getQuoteMode() != null) {
                this._format = this._format.builder().setQuoteMode(QuoteMode.valueOf(config.getQuoteMode())).build();
            }
            if (config.getRecordSeparator() != null) {
                this._format = this._format.builder().setRecordSeparator(config.getRecordSeparator()).build();
            }
            if ((nullString = config.getNullStringValue()) != null) {
                this._format = this._format.builder().setNullString(nullString).build();
            }
            if (this._isHeaderProvided) {
                this._headerMap = this.parseLineAsHeader(config.getHeader());
                this._format = this._format.builder().setHeader(this._headerMap.keySet().toArray(new String[0])).build();
                if (!this._useLineIterator) {
                    this.validateHeaderForDelimiter(delimiter, config.getHeader(), this._format);
                }
            }
            if (config.isMultiValueDelimiterEnabled()) {
                multiValueDelimiter = Character.valueOf(config.getMultiValueDelimiter());
            }
        }
        this._recordExtractor = new CSVRecordExtractor();
        this.init();
        CSVRecordExtractorConfig recordExtractorConfig = new CSVRecordExtractorConfig();
        recordExtractorConfig.setMultiValueDelimiter(multiValueDelimiter);
        recordExtractorConfig.setColumnNames(this._headerMap.keySet());
        this._recordExtractor.init(fieldsToRead, recordExtractorConfig);
    }

    private void validateHeaderForDelimiter(char delimiter, String csvHeader, CSVFormat format) throws IOException {
        CSVParser parser = format.parse(RecordReaderUtils.getBufferedReader((File)this._dataFile));
        Iterator<CSVRecord> iterator = parser.iterator();
        if (iterator.hasNext() && this.recordHasMultipleValues(iterator.next()) && this.delimiterNotPresentInHeader(delimiter, csvHeader)) {
            throw new IllegalArgumentException("Configured header does not contain the configured delimiter");
        }
    }

    private boolean recordHasMultipleValues(CSVRecord record) {
        return record.size() > 1;
    }

    private boolean delimiterNotPresentInHeader(char delimiter, String csvHeader) {
        return !StringUtils.contains((CharSequence)csvHeader, (int)delimiter);
    }

    private void init() throws IOException {
        if (this._useLineIterator) {
            this.initLineIteratorResources();
            return;
        }
        this._parser = this._format.parse(RecordReaderUtils.getBufferedReader((File)this._dataFile));
        this._headerMap = this._parser.getHeaderMap();
        this._iterator = this._parser.iterator();
    }

    public Map<String, Integer> getCSVHeaderMap() {
        return this._headerMap;
    }

    public boolean hasNext() {
        if (this._useLineIterator) {
            return this.readNextRecord();
        }
        return this._iterator.hasNext();
    }

    public GenericRow next() throws IOException {
        if (this._useLineIterator) {
            return this._nextRecord;
        }
        return this.next(new GenericRow());
    }

    public GenericRow next(GenericRow reuse) throws IOException {
        if (this._useLineIterator) {
            reuse.init(this._nextRecord);
        } else {
            CSVRecord record = this._iterator.next();
            this._recordExtractor.extract(record, reuse);
        }
        return reuse;
    }

    public void rewind() throws IOException {
        if (this._useLineIterator) {
            this.resetLineIteratorResources();
        }
        if (this._parser != null && !this._parser.isClosed()) {
            this._parser.close();
        }
        this.init();
    }

    public void close() throws IOException {
        if (this._useLineIterator) {
            this.resetLineIteratorResources();
        }
        if (this._parser != null && !this._parser.isClosed()) {
            this._parser.close();
        }
    }

    private boolean readNextRecord() {
        try {
            this._nextRecord = null;
            GenericRow genericRow = new GenericRow();
            this.readNextLine(genericRow);
            this._nextRecord = genericRow;
        }
        catch (Exception e) {
            LOGGER.info("Error parsing next record.", e);
        }
        return this._nextRecord != null;
    }

    /*
     * Loose catch block
     */
    private void readNextLine(GenericRow reuse) throws IOException {
        while (this._nextLine != null) {
            CSVParser csvParser;
            StringReader reader;
            block15: {
                block16: {
                    reader = new StringReader(this._nextLine);
                    csvParser = this._format.parse(reader);
                    List<CSVRecord> csvRecords = csvParser.getRecords();
                    if (csvRecords == null || csvRecords.size() <= 0) break block15;
                    CSVRecord record = csvRecords.get(0);
                    this._recordExtractor.extract(record, reuse);
                    if (csvParser == null) break block16;
                    csvParser.close();
                }
                ((Reader)reader).close();
                break;
            }
            try {
                try {
                    throw new NoSuchElementException("Failed to find any records");
                    {
                        catch (Throwable throwable) {
                            if (csvParser != null) {
                                try {
                                    csvParser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                }
                catch (Exception e) {
                    ++this._skippedLinesCount;
                    LOGGER.debug("Skipped input line: {} from file: {}", this._nextLine, this._dataFile, e);
                    this._nextLine = this._bufferedReader.readLine();
                    ((Reader)reader).close();
                }
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        if (this._nextLine == null) {
            throw new RuntimeException("No more parseable lines. Line iterator reached end of file.");
        }
        this._nextLine = this._bufferedReader.readLine();
    }

    private Map<String, Integer> parseLineAsHeader(String line) throws IOException {
        Map<String, Integer> headerMap;
        try (StringReader stringReader = new StringReader(line);
             CSVParser parser = this._format.parse(stringReader);){
            headerMap = parser.getHeaderMap();
        }
        return headerMap;
    }

    private void initLineIteratorResources() throws IOException {
        this._bufferedReader = new BufferedReader(new FileReader(this._dataFile), 32768);
        if (this._isHeaderProvided) {
            if (this._skipHeaderRecord) {
                this._bufferedReader.readLine();
                this._format = this._format.builder().setSkipHeaderRecord(false).build();
            }
        } else {
            String headerLine = this._bufferedReader.readLine();
            this._headerMap = this.parseLineAsHeader(headerLine);
            this._format = this._format.builder().setSkipHeaderRecord(false).setHeader(this._headerMap.keySet().toArray(new String[0])).build();
        }
        this._nextLine = this._bufferedReader.readLine();
    }

    private void resetLineIteratorResources() throws IOException {
        this._nextLine = null;
        LOGGER.info("Total lines skipped in file: {} were: {}", (Object)this._dataFile, (Object)this._skippedLinesCount);
        this._skippedLinesCount = 0L;
        if (!this._isHeaderProvided) {
            this._headerMap.clear();
        }
        if (this._bufferedReader != null) {
            this._bufferedReader.close();
        }
    }
}

