/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.csv;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.pinot.plugin.inputformat.csv.CSVMessageDecoder;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CSVMessageDecoderTest {
    @Test
    public void testHappyCase() throws Exception {
        Map<String, String> decoderProps = CSVMessageDecoderTest.getStandardDecoderProps();
        CSVMessageDecoder messageDecoder = new CSVMessageDecoder();
        messageDecoder.init(decoderProps, (Set)ImmutableSet.of((Object)"name", (Object)"age", (Object)"gender"), "");
        String incomingRecord = "Alice;18;F";
        GenericRow destination = new GenericRow();
        messageDecoder.decode(incomingRecord.getBytes(StandardCharsets.UTF_8), destination);
        Assert.assertNotNull((Object)destination.getValue("name"));
        Assert.assertNotNull((Object)destination.getValue("age"));
        Assert.assertNotNull((Object)destination.getValue("gender"));
        Assert.assertEquals((Object)destination.getValue("name"), (Object)"Alice");
        Assert.assertEquals((Object)destination.getValue("age"), (Object)"18");
        Assert.assertEquals((Object)destination.getValue("gender"), (Object)"F");
    }

    @Test
    public void testMultivalue() throws Exception {
        Map<String, String> decoderProps = CSVMessageDecoderTest.getStandardDecoderProps();
        decoderProps.put("header", "name;age;gender;subjects");
        CSVMessageDecoder messageDecoder = new CSVMessageDecoder();
        messageDecoder.init(decoderProps, (Set)ImmutableSet.of((Object)"name", (Object)"age", (Object)"gender", (Object)"subjects"), "");
        String incomingRecord = "Alice;18;F;maths,German,history";
        GenericRow destination = new GenericRow();
        messageDecoder.decode(incomingRecord.getBytes(StandardCharsets.UTF_8), destination);
        Assert.assertNotNull((Object)destination.getValue("name"));
        Assert.assertNotNull((Object)destination.getValue("age"));
        Assert.assertNotNull((Object)destination.getValue("gender"));
        Assert.assertNotNull((Object)destination.getValue("subjects"));
        Assert.assertEquals((Object)destination.getValue("name"), (Object)"Alice");
        Assert.assertEquals((Object)destination.getValue("age"), (Object)"18");
        Assert.assertEquals((Object)destination.getValue("gender"), (Object)"F");
        Assert.assertEquals((Object)destination.getValue("subjects"), (Object)new String[]{"maths", "German", "history"});
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testCommentMarker() throws Exception {
        Map<String, String> decoderProps = CSVMessageDecoderTest.getStandardDecoderProps();
        decoderProps.put("header", "name,age,gender");
        decoderProps.put("delimiter", ",");
        decoderProps.put("commentMarker", "#");
        CSVMessageDecoder messageDecoder = new CSVMessageDecoder();
        messageDecoder.init(decoderProps, (Set)ImmutableSet.of((Object)"name", (Object)"age", (Object)"gender"), "");
        String incomingRecord = "#Alice,18,F";
        GenericRow destination = new GenericRow();
        messageDecoder.decode(incomingRecord.getBytes(StandardCharsets.UTF_8), destination);
    }

    @Test
    public void testHeaderFromRecord() throws Exception {
        Map<String, String> decoderProps = CSVMessageDecoderTest.getStandardDecoderProps();
        decoderProps.remove("header");
        decoderProps.put("delimiter", ",");
        CSVMessageDecoder messageDecoder = new CSVMessageDecoder();
        messageDecoder.init(decoderProps, (Set)ImmutableSet.of((Object)"name", (Object)"age", (Object)"gender"), "");
        String incomingRecord = "name,age,gender\nAlice,18,F";
        GenericRow destination = new GenericRow();
        messageDecoder.decode(incomingRecord.getBytes(StandardCharsets.UTF_8), destination);
        Assert.assertNotNull((Object)destination.getValue("name"));
        Assert.assertNotNull((Object)destination.getValue("age"));
        Assert.assertNotNull((Object)destination.getValue("gender"));
        Assert.assertEquals((Object)destination.getValue("name"), (Object)"Alice");
        Assert.assertEquals((Object)destination.getValue("age"), (Object)"18");
        Assert.assertEquals((Object)destination.getValue("gender"), (Object)"F");
    }

    @Test
    public void testEscapeCharacter() throws Exception {
        Map<String, String> decoderProps = CSVMessageDecoderTest.getStandardDecoderProps();
        decoderProps.put("header", "name;age;gender;subjects");
        decoderProps.put("delimiter", ";");
        CSVMessageDecoder messageDecoder = new CSVMessageDecoder();
        messageDecoder.init(decoderProps, (Set)ImmutableSet.of((Object)"name", (Object)"age", (Object)"gender", (Object)"subjects"), "");
        String incomingRecord = "Alice;18;F;mat\\;hs";
        GenericRow destination = new GenericRow();
        messageDecoder.decode(incomingRecord.getBytes(StandardCharsets.UTF_8), destination);
        Assert.assertNotNull((Object)destination.getValue("name"));
        Assert.assertNotNull((Object)destination.getValue("age"));
        Assert.assertNotNull((Object)destination.getValue("gender"));
        Assert.assertNotNull((Object)destination.getValue("subjects"));
        Assert.assertEquals((Object)destination.getValue("name"), (Object)"Alice");
        Assert.assertEquals((Object)destination.getValue("age"), (Object)"18");
        Assert.assertEquals((Object)destination.getValue("gender"), (Object)"F");
        Assert.assertEquals((Object)destination.getValue("subjects"), (Object)"mat;hs");
    }

    @Test
    public void testNullString() throws Exception {
        Map<String, String> decoderProps = CSVMessageDecoderTest.getStandardDecoderProps();
        decoderProps.put("header", "name;age;gender;subjects");
        decoderProps.put("delimiter", ";");
        decoderProps.put("nullStringValue", "null");
        CSVMessageDecoder messageDecoder = new CSVMessageDecoder();
        messageDecoder.init(decoderProps, (Set)ImmutableSet.of((Object)"name", (Object)"age", (Object)"gender", (Object)"subjects"), "");
        String incomingRecord = "Alice;null;F;null";
        GenericRow destination = new GenericRow();
        messageDecoder.decode(incomingRecord.getBytes(StandardCharsets.UTF_8), destination);
        Assert.assertNotNull((Object)destination.getValue("name"));
        Assert.assertNull((Object)destination.getValue("age"));
        Assert.assertNotNull((Object)destination.getValue("gender"));
        Assert.assertNull((Object)destination.getValue("subjects"));
        Assert.assertEquals((Object)destination.getValue("name"), (Object)"Alice");
        Assert.assertEquals((Object)destination.getValue("gender"), (Object)"F");
    }

    @Test
    public void testDefaultProps() throws Exception {
        ImmutableMap decoderProps = ImmutableMap.of();
        CSVMessageDecoder messageDecoder = new CSVMessageDecoder();
        messageDecoder.init((Map)decoderProps, (Set)ImmutableSet.of((Object)"name", (Object)"age", (Object)"gender", (Object)"subjects"), "");
        String incomingRecord = "name,age,gender,subjects\nAlice,18,F,maths";
        GenericRow destination = new GenericRow();
        messageDecoder.decode(incomingRecord.getBytes(StandardCharsets.UTF_8), destination);
        Assert.assertEquals((Object)destination.getValue("name"), (Object)"Alice");
        Assert.assertEquals((Object)destination.getValue("age"), (Object)"18");
        Assert.assertEquals((Object)destination.getValue("gender"), (Object)"F");
        Assert.assertEquals((Object)destination.getValue("subjects"), (Object)"maths");
    }

    private static Map<String, String> getStandardDecoderProps() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("header", "name;age;gender");
        props.put("delimiter", ";");
        props.put("multiValueDelimiter", ",");
        props.put("escapeCharacter", "\\");
        return props;
    }
}

