/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.csv;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.StringUtils;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordExtractor;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordExtractorConfig;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordReaderConfig;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.apache.pinot.spi.data.readers.RecordReaderUtils;

public class CSVRecordReader
implements RecordReader {
    private File _dataFile;
    private CSVFormat _format;
    private CSVParser _parser;
    private Iterator<CSVRecord> _iterator;
    private CSVRecordExtractor _recordExtractor;

    public void init(File dataFile, @Nullable Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) throws IOException {
        char multiValueDelimiter;
        this._dataFile = dataFile;
        CSVRecordReaderConfig config = (CSVRecordReaderConfig)recordReaderConfig;
        if (config == null) {
            this._format = CSVFormat.DEFAULT.withDelimiter(',').withHeader(new String[0]);
            multiValueDelimiter = ';';
        } else {
            CSVFormat format;
            String formatString = config.getFileFormat();
            if (formatString == null) {
                format = CSVFormat.DEFAULT;
            } else {
                switch (formatString.toUpperCase()) {
                    case "EXCEL": {
                        format = CSVFormat.EXCEL;
                        break;
                    }
                    case "MYSQL": {
                        format = CSVFormat.MYSQL;
                        break;
                    }
                    case "RFC4180": {
                        format = CSVFormat.RFC4180;
                        break;
                    }
                    case "TDF": {
                        format = CSVFormat.TDF;
                        break;
                    }
                    default: {
                        format = CSVFormat.DEFAULT;
                    }
                }
            }
            char delimiter = config.getDelimiter();
            format = format.withDelimiter(delimiter);
            String csvHeader = config.getHeader();
            format = csvHeader == null ? format.withHeader(new String[0]) : format.withHeader(StringUtils.split((String)csvHeader, (char)delimiter));
            Character commentMarker = config.getCommentMarker();
            format = format.withCommentMarker(commentMarker);
            this._format = format = format.withEscape(config.getEscapeCharacter());
            multiValueDelimiter = config.getMultiValueDelimiter();
        }
        this._recordExtractor = new CSVRecordExtractor();
        this.init();
        CSVRecordExtractorConfig recordExtractorConfig = new CSVRecordExtractorConfig();
        recordExtractorConfig.setMultiValueDelimiter(multiValueDelimiter);
        recordExtractorConfig.setColumnNames(this._parser.getHeaderMap().keySet());
        this._recordExtractor.init(fieldsToRead, recordExtractorConfig);
    }

    private void init() throws IOException {
        this._parser = this._format.parse((Reader)RecordReaderUtils.getBufferedReader((File)this._dataFile));
        this._iterator = this._parser.iterator();
    }

    public boolean hasNext() {
        return this._iterator.hasNext();
    }

    public GenericRow next() {
        return this.next(new GenericRow());
    }

    public GenericRow next(GenericRow reuse) {
        CSVRecord record = this._iterator.next();
        this._recordExtractor.extract(record, reuse);
        return reuse;
    }

    public void rewind() throws IOException {
        this._parser.close();
        this.init();
    }

    public void close() throws IOException {
        this._parser.close();
    }
}

