/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.csv;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordExtractorConfig;
import org.apache.pinot.spi.data.readers.BaseRecordExtractor;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordExtractorConfig;

public class CSVRecordExtractor
extends BaseRecordExtractor<CSVRecord> {
    private char _multiValueDelimiter;
    private Set<String> _fields;

    public void init(Set<String> fields, RecordExtractorConfig recordExtractorConfig) {
        CSVRecordExtractorConfig csvRecordExtractorConfig = (CSVRecordExtractorConfig)recordExtractorConfig;
        this._fields = fields == null || fields.isEmpty() ? csvRecordExtractorConfig.getColumnNames() : ImmutableSet.copyOf(fields);
        this._multiValueDelimiter = csvRecordExtractorConfig.getMultiValueDelimiter();
    }

    public GenericRow extract(CSVRecord from, GenericRow to) {
        for (String fieldName : this._fields) {
            String value = from.isSet(fieldName) ? from.get(fieldName) : null;
            to.putValue(fieldName, this.convert(value));
        }
        return to;
    }

    @Nullable
    public Object convert(@Nullable Object value) {
        String stringValue = (String)value;
        if (stringValue == null || StringUtils.isEmpty((CharSequence)stringValue)) {
            return null;
        }
        String[] stringValues = StringUtils.split((String)stringValue, (char)this._multiValueDelimiter);
        int numValues = stringValues.length;
        if (numValues > 1) {
            Object[] array = new Object[numValues];
            int index = 0;
            for (String stringVal : stringValues) {
                array[index++] = stringVal;
            }
            return array;
        }
        return stringValue;
    }
}

