/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.csv;

import java.io.File;
import java.io.FileWriter;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordReader;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordReaderConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.AbstractRecordReaderTest;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.testng.Assert;

public class CSVRecordReaderTest
extends AbstractRecordReaderTest {
    private static char CSV_MULTI_VALUE_DELIMITER = (char)9;
    private final File _dataFile;

    public CSVRecordReaderTest() {
        this._dataFile = new File(this._tempDir, "data.csv");
    }

    protected RecordReader createRecordReader() throws Exception {
        CSVRecordReaderConfig csvRecordReaderConfig = new CSVRecordReaderConfig();
        csvRecordReaderConfig.setMultiValueDelimiter(CSV_MULTI_VALUE_DELIMITER);
        CSVRecordReader csvRecordReader = new CSVRecordReader();
        csvRecordReader.init(this._dataFile, this._sourceFields, (RecordReaderConfig)csvRecordReaderConfig);
        return csvRecordReader;
    }

    protected void writeRecordsToFile(List<Map<String, Object>> recordsToWrite) throws Exception {
        Schema pinotSchema = this.getPinotSchema();
        String[] columns = pinotSchema.getColumnNames().toArray(new String[0]);
        try (FileWriter fileWriter = new FileWriter(this._dataFile);
             CSVPrinter csvPrinter = new CSVPrinter((Appendable)fileWriter, CSVFormat.DEFAULT.withHeader(columns));){
            for (Map<String, Object> r : recordsToWrite) {
                Object[] record = new Object[columns.length];
                for (int i = 0; i < columns.length; ++i) {
                    record[i] = pinotSchema.getFieldSpecFor(columns[i]).isSingleValueField() ? r.get(columns[i]) : StringUtils.join((Object[])((List)r.get(columns[i])).toArray(), (char)CSV_MULTI_VALUE_DELIMITER);
                }
                csvPrinter.printRecord(record);
            }
        }
    }

    protected void checkValue(RecordReader recordReader, List<Map<String, Object>> expectedRecordsMap, List<Object[]> expectedPrimaryKeys) throws Exception {
        for (int i = 0; i < expectedRecordsMap.size(); ++i) {
            Map<String, Object> expectedRecord = expectedRecordsMap.get(i);
            GenericRow actualRecord = recordReader.next();
            for (FieldSpec fieldSpec : this._pinotSchema.getAllFieldSpecs()) {
                String fieldSpecName = fieldSpec.getName();
                if (fieldSpec.isSingleValueField()) {
                    Assert.assertEquals((String)actualRecord.getValue(fieldSpecName).toString(), (String)expectedRecord.get(fieldSpecName).toString());
                } else {
                    List expectedRecords = (List)expectedRecord.get(fieldSpecName);
                    if (expectedRecords.size() == 1) {
                        Assert.assertEquals((String)actualRecord.getValue(fieldSpecName).toString(), (String)expectedRecords.get(0).toString());
                    } else {
                        Object[] actualRecords = (Object[])actualRecord.getValue(fieldSpecName);
                        Assert.assertEquals((int)actualRecords.length, (int)expectedRecords.size());
                        for (int j = 0; j < actualRecords.length; ++j) {
                            Assert.assertEquals((String)actualRecords[j].toString(), (String)expectedRecords.get(j).toString());
                        }
                    }
                }
                PrimaryKey primaryKey = actualRecord.getPrimaryKey(this.getPrimaryKeyColumns());
                for (int j = 0; j < primaryKey.getValues().length; ++j) {
                    Assert.assertEquals((String)primaryKey.getValues()[j].toString(), (String)expectedPrimaryKeys.get(i)[j].toString());
                }
            }
        }
        Assert.assertFalse((boolean)recordReader.hasNext());
    }
}

