/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.csv;

import java.util.Set;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordExtractorConfig;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordExtractor;
import org.apache.pinot.spi.data.readers.RecordExtractorConfig;

public class CSVRecordExtractor
implements RecordExtractor<CSVRecord> {
    private char _multiValueDelimiter;
    private Set<String> _fields;

    public void init(Set<String> fields, RecordExtractorConfig recordExtractorConfig) {
        this._fields = fields;
        this._multiValueDelimiter = ((CSVRecordExtractorConfig)recordExtractorConfig).getMultiValueDelimiter();
    }

    public GenericRow extract(CSVRecord from, GenericRow to) {
        for (String fieldName : this._fields) {
            String value;
            String string = value = from.isSet(fieldName) ? from.get(fieldName) : null;
            if (value == null || StringUtils.isEmpty((CharSequence)value)) {
                to.putValue(fieldName, null);
                continue;
            }
            String[] stringValues = StringUtils.split((String)value, (char)this._multiValueDelimiter);
            int numValues = stringValues.length;
            if (numValues > 1) {
                Object[] array = new Object[numValues];
                int index = 0;
                for (String stringValue : stringValues) {
                    array[index++] = stringValue;
                }
                to.putValue(fieldName, (Object)array);
                continue;
            }
            to.putValue(fieldName, (Object)value);
        }
        return to;
    }
}

