/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.csv;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.StringUtils;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordReaderConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.apache.pinot.spi.data.readers.RecordReaderUtils;

public class CSVRecordReader
implements RecordReader {
    private File _dataFile;
    private Schema _schema;
    private List<FieldSpec> _fieldSpecs;
    private CSVFormat _format;
    private char _multiValueDelimiter;
    private CSVParser _parser;
    private Iterator<CSVRecord> _iterator;

    public void init(File dataFile, Schema schema, @Nullable RecordReaderConfig recordReaderConfig) throws IOException {
        this._dataFile = dataFile;
        this._schema = schema;
        this._fieldSpecs = RecordReaderUtils.extractFieldSpecs((Schema)schema);
        CSVRecordReaderConfig config = (CSVRecordReaderConfig)recordReaderConfig;
        if (config == null) {
            this._format = CSVFormat.DEFAULT.withDelimiter(',').withHeader(new String[0]);
            this._multiValueDelimiter = (char)59;
        } else {
            CSVFormat format;
            String formatString = config.getFileFormat();
            if (formatString == null) {
                format = CSVFormat.DEFAULT;
            } else {
                switch (formatString.toUpperCase()) {
                    case "EXCEL": {
                        format = CSVFormat.EXCEL;
                        break;
                    }
                    case "MYSQL": {
                        format = CSVFormat.MYSQL;
                        break;
                    }
                    case "RFC4180": {
                        format = CSVFormat.RFC4180;
                        break;
                    }
                    case "TDF": {
                        format = CSVFormat.TDF;
                        break;
                    }
                    default: {
                        format = CSVFormat.DEFAULT;
                    }
                }
            }
            char delimiter = config.getDelimiter();
            format = format.withDelimiter(delimiter);
            String csvHeader = config.getHeader();
            format = csvHeader == null ? format.withHeader(new String[0]) : format.withHeader(StringUtils.split((String)csvHeader, (char)delimiter));
            this._format = format;
            this._multiValueDelimiter = config.getMultiValueDelimiter();
        }
        this.init();
    }

    private void init() throws IOException {
        this._parser = this._format.parse((Reader)RecordReaderUtils.getBufferedReader((File)this._dataFile));
        this._iterator = this._parser.iterator();
    }

    public boolean hasNext() {
        return this._iterator.hasNext();
    }

    public GenericRow next() {
        return this.next(new GenericRow());
    }

    public GenericRow next(GenericRow reuse) {
        CSVRecord record = this._iterator.next();
        for (FieldSpec fieldSpec : this._fieldSpecs) {
            String value;
            String fieldName = fieldSpec.getName();
            String string = value = record.isSet(fieldName) ? record.get(fieldName) : null;
            if (fieldSpec.isSingleValueField()) {
                if (value == null && fieldSpec.getFieldType() == FieldSpec.FieldType.TIME) continue;
                reuse.putField(fieldName, RecordReaderUtils.convertSingleValue((FieldSpec)fieldSpec, (String)value));
                continue;
            }
            String[] values = value != null ? StringUtils.split((String)value, (char)this._multiValueDelimiter) : null;
            reuse.putField(fieldName, RecordReaderUtils.convertMultiValue((FieldSpec)fieldSpec, (String[])values));
        }
        return reuse;
    }

    public void rewind() throws IOException {
        this._parser.close();
        this.init();
    }

    public Schema getSchema() {
        return this._schema;
    }

    public void close() throws IOException {
        this._parser.close();
    }
}

