/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.csv;

import java.io.File;
import java.io.FileWriter;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordReader;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordReaderConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.AbstractRecordReaderTest;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;

public class CSVRecordReaderTest
extends AbstractRecordReaderTest {
    private static char CSV_MULTI_VALUE_DELIMITER = (char)9;
    private final File _dataFile;

    public CSVRecordReaderTest() {
        this._dataFile = new File(this._tempDir, "data.csv");
    }

    protected RecordReader createRecordReader() throws Exception {
        CSVRecordReaderConfig csvRecordReaderConfig = new CSVRecordReaderConfig();
        csvRecordReaderConfig.setMultiValueDelimiter(CSV_MULTI_VALUE_DELIMITER);
        CSVRecordReader csvRecordReader = new CSVRecordReader();
        csvRecordReader.init(this._dataFile, this.getPinotSchema(), (RecordReaderConfig)csvRecordReaderConfig);
        return csvRecordReader;
    }

    protected void writeRecordsToFile(List<Map<String, Object>> recordsToWrite) throws Exception {
        Schema pinotSchema = this.getPinotSchema();
        String[] columns = pinotSchema.getColumnNames().toArray(new String[0]);
        try (FileWriter fileWriter = new FileWriter(this._dataFile);
             CSVPrinter csvPrinter = new CSVPrinter((Appendable)fileWriter, CSVFormat.DEFAULT.withHeader(columns));){
            for (Map<String, Object> r : recordsToWrite) {
                Object[] record = new Object[columns.length];
                for (int i = 0; i < columns.length; ++i) {
                    record[i] = pinotSchema.getFieldSpecFor(columns[i]).isSingleValueField() ? r.get(columns[i]) : StringUtils.join((Object[])((List)r.get(columns[i])).toArray(), (char)CSV_MULTI_VALUE_DELIMITER);
                }
                csvPrinter.printRecord(record);
            }
        }
    }
}

