/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.csv;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordReader;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordReaderConfig;
import org.apache.pinot.spi.data.readers.AbstractRecordExtractorTest;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CSVRecordExtractorTest
extends AbstractRecordExtractorTest {
    private static final char CSV_MULTI_VALUE_DELIMITER = ';';
    private final File _dataFile;

    public CSVRecordExtractorTest() {
        this._dataFile = new File(this._tempDir, "events.csv");
    }

    protected RecordReader createRecordReader(Set<String> fieldsToRead) throws IOException {
        CSVRecordReaderConfig csvRecordReaderConfig = new CSVRecordReaderConfig();
        csvRecordReaderConfig.setMultiValueDelimiter(';');
        CSVRecordReader csvRecordReader = new CSVRecordReader();
        csvRecordReader.init(this._dataFile, fieldsToRead, (RecordReaderConfig)csvRecordReaderConfig);
        return csvRecordReader;
    }

    public void createInputFile() throws IOException {
        String[] header = this._sourceFieldNames.toArray(new String[0]);
        try (FileWriter fileWriter = new FileWriter(this._dataFile);
             CSVPrinter csvPrinter = new CSVPrinter((Appendable)fileWriter, CSVFormat.DEFAULT.withHeader(header));){
            for (Map inputRecord : this._inputRecords) {
                Object[] record = new Object[header.length];
                for (int i = 0; i < header.length; ++i) {
                    Object value = inputRecord.get(header[i]);
                    record[i] = value instanceof Collection ? StringUtils.join((Object[])((List)value).toArray(), (char)';') : value;
                }
                csvPrinter.printRecord(record);
            }
        }
    }

    protected void checkValue(Map<String, Object> inputRecord, GenericRow genericRow) {
        for (Map.Entry<String, Object> entry : inputRecord.entrySet()) {
            String columnName = entry.getKey();
            Object expectedValue = entry.getValue();
            Object actualValue = genericRow.getValue(columnName);
            if (expectedValue instanceof Collection) {
                List expectedArray = (List)expectedValue;
                if (expectedArray.size() == 1) {
                    Assert.assertEquals((Object)actualValue, (Object)String.valueOf(expectedArray.get(0)));
                    continue;
                }
                Object[] actualArray = (Object[])actualValue;
                for (int j = 0; j < actualArray.length; ++j) {
                    Assert.assertEquals((Object)actualArray[j], (Object)String.valueOf(expectedArray.get(j)));
                }
                continue;
            }
            Assert.assertEquals((Object)actualValue, (Object)(expectedValue == null ? null : String.valueOf(expectedValue)));
        }
    }

    @Test
    public void testRemovingSurroundingSpaces() throws IOException {
        CSVRecordReaderConfig csvRecordReaderConfig = new CSVRecordReaderConfig();
        File spaceFile = new File(this._tempDir, "space.csv");
        BufferedWriter writer = new BufferedWriter(new FileWriter(spaceFile));
        writer.write("col1 ,col2\n");
        writer.write(" value11, value12");
        writer.close();
        CSVRecordReader csvRecordReader = new CSVRecordReader();
        HashSet<String> fieldsToRead = new HashSet<String>();
        fieldsToRead.add("col1");
        fieldsToRead.add("col2");
        csvRecordReader.init(spaceFile, fieldsToRead, (RecordReaderConfig)csvRecordReaderConfig);
        GenericRow genericRow = new GenericRow();
        csvRecordReader.rewind();
        Assert.assertTrue((boolean)csvRecordReader.hasNext());
        csvRecordReader.next(genericRow);
        Assert.assertEquals((Object)genericRow.getValue("col1"), (Object)"value11");
        Assert.assertEquals((Object)genericRow.getValue("col2"), (Object)"value12");
    }

    @Test
    public void testIgnoringSurroundingSpaces() throws IOException {
        CSVRecordReaderConfig csvRecordReaderConfig = new CSVRecordReaderConfig();
        File spaceFile = new File(this._tempDir, "space.csv");
        BufferedWriter writer = new BufferedWriter(new FileWriter(spaceFile));
        writer.write("col1 ,col2\n");
        writer.write("\"value11\",\" value12\"");
        writer.close();
        CSVRecordReader csvRecordReader = new CSVRecordReader();
        HashSet<String> fieldsToRead = new HashSet<String>();
        fieldsToRead.add("col1");
        fieldsToRead.add("col2");
        csvRecordReader.init(spaceFile, fieldsToRead, (RecordReaderConfig)csvRecordReaderConfig);
        GenericRow genericRow = new GenericRow();
        csvRecordReader.rewind();
        Assert.assertTrue((boolean)csvRecordReader.hasNext());
        csvRecordReader.next(genericRow);
        Assert.assertEquals((Object)genericRow.getValue("col1"), (Object)"value11");
        Assert.assertEquals((Object)genericRow.getValue("col2"), (Object)" value12");
    }

    @Test
    public void testEscapeCharacterInCSV() throws Exception {
        CSVRecordReaderConfig csvRecordReaderConfig = new CSVRecordReaderConfig();
        csvRecordReaderConfig.setEscapeCharacter(Character.valueOf('\\'));
        File escapedFile = new File(this._tempDir, "escape.csv");
        BufferedWriter writer = new BufferedWriter(new FileWriter(escapedFile));
        writer.write("first,second\n");
        writer.write("string1, string2\\, string3");
        writer.close();
        CSVRecordReader csvRecordReader = new CSVRecordReader();
        HashSet<String> fieldsToRead = new HashSet<String>();
        fieldsToRead.add("first");
        fieldsToRead.add("second");
        csvRecordReader.init(escapedFile, fieldsToRead, (RecordReaderConfig)csvRecordReaderConfig);
        GenericRow genericRow = new GenericRow();
        csvRecordReader.rewind();
        Assert.assertTrue((boolean)csvRecordReader.hasNext());
        csvRecordReader.next(genericRow);
        Assert.assertEquals((Object)genericRow.getValue("first"), (Object)"string1");
        Assert.assertEquals((Object)genericRow.getValue("second"), (Object)"string2, string3");
    }
}

