/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.loadbalancer.service;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.phoenix.loadbalancer.service.LoadBalanceZookeeperConfImpl;
import org.junit.Assert;
import org.junit.Test;

public class LoadBalanceZookeeperConfImplTest {
    @Test
    public void testZkConnectString() {
        this.testZKClusterKey("server:2183", "2182");
        this.testZKClusterKey("server1:2182,server2:2183,server3:2184", "2181");
        this.testZKClusterKey("server1,server2:2181,server3:2182", "2181");
        this.testZKClusterKey("server1:2182,server2,server3:2183", "2181");
        this.testZKClusterKey("server1:2182,server2:2183,server3", "2181");
        this.testZKClusterKey("server1:2182,server2,server3:2183", "2184");
        this.testZKClusterKey("server1,server2,server3", "");
        this.testZKClusterKey("server1:2182,server2,server3:2183", "");
    }

    private void testZKClusterKey(String quorum, String port) {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.zookeeper.quorum", quorum);
        conf.set("hbase.zookeeper.property.clientPort", port);
        LoadBalanceZookeeperConfImpl loadBalanceZookeeperConf = new LoadBalanceZookeeperConfImpl(conf);
        String[] connectStrings = loadBalanceZookeeperConf.getZkConnectString().split(",");
        String[] quorums = quorum.split(",");
        Assert.assertTrue((connectStrings.length == quorums.length ? 1 : 0) != 0);
        for (int i = 0; i < connectStrings.length; ++i) {
            if (quorums[i].contains(":")) {
                Assert.assertEquals((Object)quorums[i], (Object)connectStrings[i]);
                continue;
            }
            Assert.assertEquals((Object)(quorums[i] + ":" + port), (Object)connectStrings[i]);
        }
    }
}

