/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.rules;

import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataSequence;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.rules.DataValue;
import org.apache.phoenix.pherf.rules.SequentialVarcharDataGenerator;
import org.junit.Assert;
import org.junit.Test;

public class SequentialVarcharDataGeneratorTest {
    SequentialVarcharDataGenerator generator;

    @Test(expected=IllegalArgumentException.class)
    public void testRejectsNonSequential() {
        Column columnA = new Column();
        columnA.setType(DataTypeMapping.VARCHAR);
        columnA.setDataSequence(DataSequence.RANDOM);
        this.generator = new SequentialVarcharDataGenerator(columnA);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRejectsNonVarchar() {
        Column columnA = new Column();
        columnA.setType(DataTypeMapping.INTEGER);
        columnA.setDataSequence(DataSequence.SEQUENTIAL);
        this.generator = new SequentialVarcharDataGenerator(columnA);
    }

    @Test
    public void testGetDataValue() {
        Column columnA = new Column();
        columnA.setType(DataTypeMapping.VARCHAR);
        columnA.setLength(15);
        columnA.setDataSequence(DataSequence.SEQUENTIAL);
        this.generator = new SequentialVarcharDataGenerator(columnA);
        DataValue result1 = this.generator.getDataValue();
        Assert.assertEquals((Object)"xxxxxxxxxxxxxx0", (Object)result1.getValue());
        DataValue result2 = this.generator.getDataValue();
        Assert.assertEquals((Object)"xxxxxxxxxxxxxx1", (Object)result2.getValue());
        DataValue result3 = this.generator.getDataValue();
        Assert.assertEquals((Object)"xxxxxxxxxxxxxx2", (Object)result3.getValue());
        DataValue result4 = this.generator.getDataValue();
        Assert.assertEquals((Object)"xxxxxxxxxxxxxx3", (Object)result4.getValue());
    }
}

