/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.rules;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataSequence;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.rules.DataValue;
import org.apache.phoenix.pherf.rules.SequentialListDataGenerator;
import org.junit.Assert;
import org.junit.Test;

public class SequentialListDataGeneratorTest {
    SequentialListDataGenerator generator;

    @Test(expected=IllegalArgumentException.class)
    public void testRejectsNonSequential() {
        Column columnA = new Column();
        columnA.setType(DataTypeMapping.VARCHAR);
        columnA.setDataSequence(DataSequence.RANDOM);
        this.generator = new SequentialListDataGenerator(columnA);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRejectsNonVarchar() {
        DateTimeFormatter FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        LocalDateTime startDateTime = LocalDateTime.now();
        String formattedDateTime = startDateTime.format(FMT);
        Column columnA = new Column();
        columnA.setType(DataTypeMapping.DATE);
        columnA.setDataSequence(DataSequence.SEQUENTIAL);
        ArrayList<DataValue> values = new ArrayList<DataValue>();
        values.add(new DataValue(DataTypeMapping.DATE, formattedDateTime));
        values.add(new DataValue(DataTypeMapping.DATE, formattedDateTime));
        values.add(new DataValue(DataTypeMapping.DATE, formattedDateTime));
        columnA.setDataValues(values);
        this.generator = new SequentialListDataGenerator(columnA);
    }

    @Test
    public void testGetDataValue() {
        Column columnA = new Column();
        columnA.setType(DataTypeMapping.VARCHAR);
        columnA.setDataSequence(DataSequence.SEQUENTIAL);
        ArrayList<DataValue> values = new ArrayList<DataValue>();
        values.add(new DataValue(DataTypeMapping.VARCHAR, "A"));
        values.add(new DataValue(DataTypeMapping.VARCHAR, "B"));
        values.add(new DataValue(DataTypeMapping.VARCHAR, "C"));
        columnA.setDataValues(values);
        this.generator = new SequentialListDataGenerator(columnA);
        DataValue result1 = this.generator.getDataValue();
        Assert.assertEquals((Object)"A", (Object)result1.getValue());
        DataValue result2 = this.generator.getDataValue();
        Assert.assertEquals((Object)"B", (Object)result2.getValue());
        DataValue result3 = this.generator.getDataValue();
        Assert.assertEquals((Object)"C", (Object)result3.getValue());
        DataValue result4 = this.generator.getDataValue();
        Assert.assertEquals((Object)"A", (Object)result4.getValue());
    }
}

