/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.rules;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataSequence;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.rules.DataValue;
import org.apache.phoenix.pherf.rules.SequentialDateDataGenerator;
import org.junit.Assert;
import org.junit.Test;

public class SequentialDateDataGeneratorTest {
    SequentialDateDataGenerator generator;

    @Test(expected=IllegalArgumentException.class)
    public void testRejectsNonSequential() {
        Column columnA = new Column();
        columnA.setType(DataTypeMapping.DATE);
        columnA.setDataSequence(DataSequence.RANDOM);
        this.generator = new SequentialDateDataGenerator(columnA);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRejectsNonDate() {
        Column columnA = new Column();
        columnA.setType(DataTypeMapping.VARCHAR);
        columnA.setDataSequence(DataSequence.SEQUENTIAL);
        this.generator = new SequentialDateDataGenerator(columnA);
    }

    @Test
    public void testGetDataValue() {
        DateTimeFormatter FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        Column columnA = new Column();
        columnA.setType(DataTypeMapping.DATE);
        columnA.setDataSequence(DataSequence.SEQUENTIAL);
        this.generator = new SequentialDateDataGenerator(columnA);
        LocalDateTime startDateTime = this.generator.getStartDateTime();
        DataValue result1 = this.generator.getDataValue();
        LocalDateTime result1LocalTime = LocalDateTime.parse(result1.getValue(), FMT);
        Assert.assertFalse((boolean)result1LocalTime.isBefore(startDateTime));
        DataValue result2 = this.generator.getDataValue();
        LocalDateTime result2LocalTime = LocalDateTime.parse(result2.getValue(), FMT);
        Assert.assertEquals((Object)result2LocalTime.minusSeconds(1L), (Object)result1LocalTime);
        DataValue result3 = this.generator.getDataValue();
        LocalDateTime result3LocalTime = LocalDateTime.parse(result3.getValue(), FMT);
        Assert.assertEquals((Object)result3LocalTime.minusSeconds(1L), (Object)result2LocalTime);
        DataValue result4 = this.generator.getDataValue();
        LocalDateTime result4LocalTime = LocalDateTime.parse(result4.getValue(), FMT);
        Assert.assertEquals((Object)result4LocalTime.minusSeconds(1L), (Object)result3LocalTime);
    }
}

