/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf;

import java.util.Properties;
import org.apache.phoenix.pherf.Pherf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.ExpectedSystemExit;

public class PherfTest {
    @Rule
    public final ExpectedSystemExit exit = ExpectedSystemExit.none();

    @Test
    public void testListArgument() {
        String[] args = new String[]{"-listFiles"};
        Pherf.main((String[])args);
    }

    @Test
    public void testUnknownOption() {
        String[] args = new String[]{"-drop", "all", "-q", "-m", "-unknownOption"};
        this.exit.expectSystemExitWithStatus(1);
        Pherf.main((String[])args);
    }

    @Test
    public void testLongOptions() throws Exception {
        String extension = ".sql";
        String args = "testArgs";
        Long numericArg = 15L;
        String[] longOptionArgs = new String[]{"--schemaFile", ".*" + extension, "--disableSchemaApply", "--disableRuntimeResult", "--listFiles", "--scenarioFile", args, "--scenarioName", args, "--useAverageCompareType"};
        Assert.assertNotNull((Object)new Pherf(longOptionArgs));
        String[] otherLongOptionArgs = new String[]{"--drop", args, "--monitorFrequency", args, "--rowCountOverride", numericArg.toString(), "--hint", args, "--log_per_nrows", numericArg.toString(), "--diff", "--export", "--writerThreadSize", args, "--stats", "--label", args, "--compare", args};
        Assert.assertNotNull((Object)new Pherf(otherLongOptionArgs));
    }

    @Test
    public void testDefaultLogPerNRowsArgument() throws Exception {
        String[] args = new String[]{"-listFiles"};
        Assert.assertEquals((Object)1000000L, (Object)this.getLogPerNRowsValue(new Pherf(args).getProperties()));
    }

    @Test
    public void testCustomizedLogPerNRowsArgument() throws Exception {
        Long customizedPerNRows = 15L;
        String[] args = new String[]{"-listFiles", "-log_per_nrows", customizedPerNRows.toString()};
        Assert.assertEquals((Object)customizedPerNRows, (Object)this.getLogPerNRowsValue(new Pherf(args).getProperties()));
    }

    @Test
    public void testInvalidLogPerNRowsArgument() throws Exception {
        Long zero = 0L;
        Long negativeOne = -1L;
        String invaildNum = "abc";
        String[] args = new String[]{"-listFiles", "-log_per_nrows", zero.toString()};
        Assert.assertEquals((Object)1000000L, (Object)this.getLogPerNRowsValue(new Pherf(args).getProperties()));
        String[] args2 = new String[]{"-listFiles", "-log_per_nrows", negativeOne.toString()};
        Assert.assertEquals((Object)1000000L, (Object)this.getLogPerNRowsValue(new Pherf(args2).getProperties()));
        String[] args3 = new String[]{"-listFiles", "-log_per_nrows", invaildNum};
        Assert.assertEquals((Object)1000000L, (Object)this.getLogPerNRowsValue(new Pherf(args3).getProperties()));
    }

    private Long getLogPerNRowsValue(Properties prop) {
        return Long.valueOf(prop.getProperty("pherf.default.log_per_nrows"));
    }
}

