/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.pherf.Pherf;
import org.apache.phoenix.pherf.ResultBaseTestIT;
import org.apache.phoenix.pherf.result.Result;
import org.apache.phoenix.pherf.result.ResultValue;
import org.apache.phoenix.pherf.result.file.ResultFileDetails;
import org.apache.phoenix.pherf.result.impl.CSVFileResultHandler;
import org.apache.phoenix.pherf.workload.mt.MultiTenantTestUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.ExpectedSystemExit;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PherfMainIT
extends ResultBaseTestIT {
    @Rule
    public final ExpectedSystemExit exit = ExpectedSystemExit.none();

    public HashMap<String, String> mapResults(Result r) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        List resultValues = r.getResultValues();
        String[] headerValues = r.getHeader().split(",");
        for (int i = 0; i < headerValues.length; ++i) {
            map.put(StringUtils.strip((String)headerValues[i], (String)"[] "), StringUtils.strip((String)((ResultValue)resultValues.get(i)).toString(), (String)"[] "));
        }
        return map;
    }

    @Test
    public void testPherfMain() throws Exception {
        String[] args = new String[]{"-q", "-l", "-z", MultiTenantTestUtils.getZookeeperFromUrl(url), "-schemaFile", ".*create_prod_test_unsalted.sql", "-scenarioFile", ".*prod_test_unsalted_scenario.xml"};
        Pherf pherf = new Pherf(args);
        pherf.run();
        for (Future future : pherf.workloadExecutor.jobs.values()) {
            future.get();
        }
    }

    @Test
    public void testQueryTimeout() throws Exception {
        String[] args = new String[]{"-q", "-l", "-z", MultiTenantTestUtils.getZookeeperFromUrl(url), "-drop", "all", "-schemaFile", ".*timeout_test_schema.sql", "-scenarioFile", ".*scenario_with_query_timeouts.xml"};
        Pherf p = new Pherf(args);
        p.run();
        CSVFileResultHandler rh = new CSVFileResultHandler();
        rh.setResultFileDetails(ResultFileDetails.CSV_DETAILED_PERFORMANCE);
        rh.setResultFileName("COMBINED");
        List resultList = rh.read();
        for (Result r : resultList) {
            HashMap<String, String> resultsMap = this.mapResults(r);
            if (!resultsMap.get("QUERY_ID").equals("q1")) continue;
            Assert.assertEquals((Object)resultsMap.get("TIMED_OUT"), (Object)"true");
        }
    }

    @Test
    public void testLargeQueryTimeout() throws Exception {
        String[] args = new String[]{"-q", "-l", "-z", MultiTenantTestUtils.getZookeeperFromUrl(url), "-drop", "all", "-schemaFile", ".*timeout_test_schema.sql", "-scenarioFile", ".*scenario_with_query_timeouts.xml"};
        Pherf p = new Pherf(args);
        p.run();
        CSVFileResultHandler rh = new CSVFileResultHandler();
        rh.setResultFileDetails(ResultFileDetails.CSV_DETAILED_PERFORMANCE);
        rh.setResultFileName("COMBINED");
        List resultList = rh.read();
        for (Result r : resultList) {
            HashMap<String, String> resultsMap = this.mapResults(r);
            if (!resultsMap.get("QUERY_ID").equals("q2")) continue;
            Assert.assertEquals((Object)resultsMap.get("TIMED_OUT"), (Object)"false");
        }
    }

    @Test
    public void testNoQueryTimeout() throws Exception {
        String[] args = new String[]{"-q", "-l", "-z", MultiTenantTestUtils.getZookeeperFromUrl(url), "-drop", "all", "-schemaFile", ".*timeout_test_schema.sql", "-scenarioFile", ".*scenario_with_query_timeouts.xml"};
        Pherf p = new Pherf(args);
        p.run();
        CSVFileResultHandler rh = new CSVFileResultHandler();
        rh.setResultFileDetails(ResultFileDetails.CSV_DETAILED_PERFORMANCE);
        rh.setResultFileName("COMBINED");
        List resultList = rh.read();
        for (Result r : resultList) {
            HashMap<String, String> resultsMap = this.mapResults(r);
            if (!resultsMap.get("QUERY_ID").equals("q3")) continue;
            Assert.assertEquals((Object)resultsMap.get("TIMED_OUT"), (Object)"false");
        }
    }
}

