/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.result;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.result.DataLoadThreadTime;
import org.apache.phoenix.pherf.result.DataLoadTimeSummary;
import org.apache.phoenix.pherf.result.DataModelResult;
import org.apache.phoenix.pherf.result.QueryResult;
import org.apache.phoenix.pherf.result.QuerySetResult;
import org.apache.phoenix.pherf.result.Result;
import org.apache.phoenix.pherf.result.ResultHandler;
import org.apache.phoenix.pherf.result.ResultValue;
import org.apache.phoenix.pherf.result.ScenarioResult;
import org.apache.phoenix.pherf.result.TableLoadTime;
import org.apache.phoenix.pherf.result.WriteThreadTime;
import org.apache.phoenix.pherf.result.file.ResultFileDetails;
import org.apache.phoenix.pherf.result.impl.CSVFileResultHandler;
import org.apache.phoenix.pherf.result.impl.CSVResultHandler;
import org.apache.phoenix.pherf.util.PhoenixUtil;

public class ResultUtil {
    private static String FILE_SUFFIX = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(DataLoadThreadTime dataLoadThreadTime) throws IOException {
        this.ensureBaseResultDirExists();
        CSVResultHandler writer = null;
        try {
            if (!dataLoadThreadTime.getThreadTime().isEmpty()) {
                writer = new CSVFileResultHandler();
                writer.setResultFileDetails(ResultFileDetails.CSV);
                writer.setResultFileName("Data_Load_Details");
                for (WriteThreadTime writeThreadTime : dataLoadThreadTime.getThreadTime()) {
                    ArrayList<ResultValue> rowValues = new ArrayList<ResultValue>();
                    rowValues.add(new ResultValue<String>(PhoenixUtil.getZookeeper()));
                    rowValues.addAll(writeThreadTime.getCsvRepresentation(this));
                    Result result = new Result(ResultFileDetails.CSV_DETAILED_PERFORMANCE, "ZK," + dataLoadThreadTime.getCsvTitle(), rowValues);
                    writer.write(result);
                }
            }
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(DataLoadTimeSummary dataLoadTime) throws IOException {
        this.ensureBaseResultDirExists();
        CSVFileResultHandler writer = null;
        ResultFileDetails resultFileDetails = PhoenixUtil.isThinDriver() ? ResultFileDetails.CSV_THIN_AGGREGATE_DATA_LOAD : ResultFileDetails.CSV_AGGREGATE_DATA_LOAD;
        try {
            writer = new CSVFileResultHandler();
            writer.setResultFileDetails(resultFileDetails);
            writer.setResultFileName("Data_Load_Summary");
            for (TableLoadTime loadTime : dataLoadTime.getTableLoadTime()) {
                ArrayList<ResultValue> rowValues = new ArrayList<ResultValue>();
                if (PhoenixUtil.isThinDriver()) {
                    rowValues.add(new ResultValue<String>(PhoenixUtil.getQueryServerUrl()));
                } else {
                    rowValues.add(new ResultValue<String>(PhoenixUtil.getZookeeper()));
                }
                rowValues.addAll(loadTime.getCsvRepresentation(this));
                Result result = new Result(resultFileDetails, resultFileDetails.getHeader().toString(), rowValues);
                ((CSVResultHandler)writer).write(result);
            }
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    public synchronized void write(ResultHandler resultHandler, DataModelResult dataModelResult) throws Exception {
        ResultFileDetails resultFileDetails = resultHandler.getResultFileDetails();
        switch (resultFileDetails) {
            case CSV_AGGREGATE_PERFORMANCE: 
            case CSV_DETAILED_PERFORMANCE: 
            case CSV_DETAILED_FUNCTIONAL: {
                List<List<ResultValue>> rowDetails = this.getCSVResults(dataModelResult, resultFileDetails);
                for (List<ResultValue> row : rowDetails) {
                    Result result = new Result(resultFileDetails, resultFileDetails.getHeader().toString(), row);
                    resultHandler.write(result);
                }
                break;
            }
            default: {
                ArrayList<ResultValue> resultValue = new ArrayList<ResultValue>();
                resultValue.add(new ResultValue<DataModelResult>(dataModelResult));
                resultHandler.write(new Result(resultFileDetails, null, resultValue));
            }
        }
    }

    public void ensureBaseResultDirExists() {
        PherfConstants constants = PherfConstants.create();
        String resultDir = constants.getProperty("pherf.default.results.dir");
        this.ensureBaseDirExists(resultDir);
    }

    public void ensureBaseDirExists(String directory) {
        File baseDir = new File(directory);
        if (!baseDir.exists()) {
            baseDir.mkdir();
        }
    }

    public void deleteDir(String directory) throws IOException {
        File baseDir = new File(directory);
        if (baseDir.exists()) {
            FileUtils.deleteDirectory((File)baseDir);
        }
    }

    public String getSuffix() {
        if (null == FILE_SUFFIX) {
            Date date = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("YYYY-MM-dd_hh-mm-ss");
            FILE_SUFFIX = formatter.format((Object)date);
        }
        return "_" + FILE_SUFFIX;
    }

    public String convertNull(String str) {
        if (str == null || str.equals("")) {
            return "null";
        }
        return str;
    }

    public Result getCSVHeaderAsResult(String row) {
        ArrayList<ResultValue> resultValues = new ArrayList<ResultValue>();
        resultValues.add(new ResultValue<String>(row));
        return new Result(ResultFileDetails.CSV, row, resultValues);
    }

    private List<List<ResultValue>> getCSVResults(DataModelResult dataModelResult, ResultFileDetails resultFileDetails) {
        ArrayList<List<ResultValue>> rowList = new ArrayList<List<ResultValue>>();
        for (ScenarioResult result : dataModelResult.getScenarioResult()) {
            for (QuerySetResult querySetResult : result.getQuerySetResult()) {
                block6: for (QueryResult queryResult : querySetResult.getQueryResults()) {
                    switch (resultFileDetails) {
                        case CSV_AGGREGATE_PERFORMANCE: {
                            List<ResultValue> csvResult = queryResult.getCsvRepresentation(this);
                            rowList.add(csvResult);
                            break;
                        }
                        case CSV_DETAILED_PERFORMANCE: 
                        case CSV_DETAILED_FUNCTIONAL: {
                            List<List<ResultValue>> detailedRows = queryResult.getCsvDetailedRepresentation(this, resultFileDetails);
                            for (List<ResultValue> detailedRowList : detailedRows) {
                                ArrayList<ResultValue> valueList = new ArrayList<ResultValue>();
                                valueList.add(new ResultValue<String>(this.convertNull(result.getTableName())));
                                valueList.add(new ResultValue<String>(this.convertNull(result.getName())));
                                valueList.add(new ResultValue<String>(this.convertNull(dataModelResult.getZookeeper())));
                                valueList.add(new ResultValue<String>(this.convertNull(String.valueOf(result.getRowCount()))));
                                valueList.add(new ResultValue<String>(this.convertNull(String.valueOf(querySetResult.getNumberOfExecutions()))));
                                valueList.add(new ResultValue<String>(this.convertNull(String.valueOf((Object)querySetResult.getExecutionType()))));
                                if (result.getPhoenixProperties() != null) {
                                    String props = this.buildProperty(result);
                                    valueList.add(new ResultValue<String>(this.convertNull(props)));
                                } else {
                                    valueList.add(new ResultValue<String>("null"));
                                }
                                valueList.addAll(detailedRowList);
                                rowList.add(valueList);
                            }
                            continue block6;
                        }
                    }
                }
            }
        }
        return rowList;
    }

    private String buildProperty(ScenarioResult result) {
        StringBuffer sb = new StringBuffer();
        boolean firstPartialSeparator = true;
        for (Map.Entry<String, String> entry : result.getPhoenixProperties().entrySet()) {
            if (!firstPartialSeparator) {
                sb.append("|");
            }
            firstPartialSeparator = false;
            sb.append(entry.getKey() + "=" + entry.getValue());
        }
        return sb.toString();
    }

    public static void setFileSuffix(String suffix) {
        FILE_SUFFIX = suffix;
    }
}

