/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.configuration;

import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.apache.phoenix.pherf.configuration.DataSequence;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.rules.DataValue;

public class Column {
    private String name;
    private String prefix;
    private DataSequence dataSequence;
    private int length = Integer.MIN_VALUE;
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MIN_VALUE;
    private int precision = Integer.MIN_VALUE;
    private int nullChance = Integer.MIN_VALUE;
    private boolean userDefined = false;
    private List<DataValue> dataValues;
    private DataTypeMapping type;
    private boolean useCurrentDate = false;

    public Column() {
    }

    public Column(Column column) {
        this();
        this.type = column.type;
        this.mutate(column);
    }

    public boolean equals(Object column) {
        Column col = (Column)column;
        return this.getType() == col.getType();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataSequence getDataSequence() {
        return this.dataSequence;
    }

    public void setDataSequence(DataSequence dataSequence) {
        this.dataSequence = dataSequence;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public DataTypeMapping getType() {
        return this.type;
    }

    public void setType(DataTypeMapping type) {
        this.type = type;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void setUseCurrentDate(boolean useCurrentDate) {
        this.useCurrentDate = useCurrentDate;
    }

    public boolean getUseCurrentDate() {
        return this.useCurrentDate;
    }

    public void mutate(Column column) {
        if (column.getMinValue() != Integer.MIN_VALUE) {
            this.setMinValue(column.getMinValue());
        }
        if (column.getMaxValue() != Integer.MIN_VALUE) {
            this.setMaxValue(column.getMaxValue());
        }
        if (column.getLength() != Integer.MIN_VALUE) {
            this.setLength(column.getLength());
        }
        if (column.getName() != null) {
            this.setName(column.getName());
        }
        if (column.getPrefix() != null) {
            this.setPrefix(column.getPrefix());
        }
        if (column.getDataSequence() != null) {
            this.setDataSequence(column.getDataSequence());
        }
        if (column.getNullChance() != Integer.MIN_VALUE) {
            this.setNullChance(column.getNullChance());
        }
        if (column.getPrecision() != Integer.MIN_VALUE) {
            this.setPrecision(column.getPrecision());
        }
        if (column.isUserDefined()) {
            this.setUserDefined(column.isUserDefined());
        }
        if (column.dataValues != null) {
            this.setDataValues(column.getDataValues());
        }
        if (column.getUseCurrentDate()) {
            this.setUseCurrentDate(column.getUseCurrentDate());
        }
    }

    public int getNullChance() {
        return this.nullChance;
    }

    public void setNullChance(int nullChance) {
        this.nullChance = nullChance;
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(boolean userDefined) {
        this.userDefined = userDefined;
    }

    public List<DataValue> getDataValues() {
        return this.dataValues;
    }

    @XmlElementWrapper(name="valuelist")
    @XmlElement(name="datavalue")
    public void setDataValues(List<DataValue> dataValues) {
        this.dataValues = dataValues;
        for (DataValue value : dataValues) {
            value.setType(this.getType());
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

