/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.result;

import java.util.Comparator;
import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;

public class RunTime
implements Comparator<RunTime>,
Comparable<RunTime> {
    private Date startTime;
    private Integer elapsedDurationInMs;
    private String message;
    private Long resultRowCount;
    private String explainPlan;

    public RunTime() {
    }

    public RunTime(Integer elapsedDurationInMs) {
        this(null, elapsedDurationInMs);
    }

    public RunTime(Long resultRowCount, Integer elapsedDurationInMs) {
        this(null, resultRowCount, elapsedDurationInMs);
    }

    public RunTime(Date startTime, Long resultRowCount, Integer elapsedDurationInMs) {
        this(null, null, startTime, resultRowCount, elapsedDurationInMs);
    }

    public RunTime(String message, Date startTime, Long resultRowCount, Integer elapsedDurationInMs) {
        this(message, null, startTime, resultRowCount, elapsedDurationInMs);
    }

    public RunTime(String message, String explainPlan, Date startTime, Long resultRowCount, Integer elapsedDurationInMs) {
        this.elapsedDurationInMs = elapsedDurationInMs;
        this.startTime = startTime;
        this.resultRowCount = resultRowCount;
        this.message = message;
        this.explainPlan = explainPlan;
    }

    @XmlAttribute
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @XmlAttribute
    public Integer getElapsedDurationInMs() {
        return this.elapsedDurationInMs;
    }

    public void setElapsedDurationInMs(Integer elapsedDurationInMs) {
        this.elapsedDurationInMs = elapsedDurationInMs;
    }

    @Override
    public int compare(RunTime r1, RunTime r2) {
        return r1.getElapsedDurationInMs().compareTo(r2.getElapsedDurationInMs());
    }

    @Override
    public int compareTo(RunTime o) {
        return this.compare(this, o);
    }

    @XmlAttribute
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @XmlAttribute
    public String getExplainPlan() {
        return this.explainPlan;
    }

    public void setExplainPlan(String explainPlan) {
        this.explainPlan = explainPlan;
    }

    @XmlAttribute
    public Long getResultRowCount() {
        return this.resultRowCount;
    }

    public void setResultRowCount(Long resultRowCount) {
        this.resultRowCount = resultRowCount;
    }
}

