/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.configuration;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import org.apache.phoenix.pherf.configuration.ExecutionType;
import org.apache.phoenix.pherf.configuration.Query;

public class QuerySet {
    private List<Query> query = new ArrayList<Query>();
    private String concurrency = "1";
    private long numberOfExecutions = 10L;
    private long executionDurationInMs = 10000L;
    private ExecutionType executionType = ExecutionType.SERIAL;

    public List<Query> getQuery() {
        return this.query;
    }

    public void setQuery(List<Query> query) {
        this.query = query;
    }

    @XmlAttribute
    public String getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(String concurrency) {
        this.concurrency = concurrency;
    }

    @XmlAttribute
    public long getNumberOfExecutions() {
        return this.numberOfExecutions;
    }

    public void setNumberOfExecutions(long numberOfExecutions) {
        this.numberOfExecutions = numberOfExecutions;
    }

    public int getMinConcurrency() {
        return this.getConcurrencyMinMax(0);
    }

    public int getMaxConcurrency() {
        return this.getConcurrencyMinMax(1);
    }

    private int getConcurrencyMinMax(int idx) {
        if (null == this.getConcurrency()) {
            return 1;
        }
        String[] concurrencySplit = this.getConcurrency().split("-");
        if (concurrencySplit.length == 2) {
            return Integer.parseInt(concurrencySplit[idx]);
        }
        return Integer.parseInt(this.getConcurrency());
    }

    @XmlAttribute
    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    public void setExecutionType(ExecutionType executionType) {
        this.executionType = executionType;
    }

    @XmlAttribute
    public long getExecutionDurationInMs() {
        return this.executionDurationInMs;
    }

    public void setExecutionDurationInMs(long executionDurationInMs) {
        this.executionDurationInMs = executionDurationInMs;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Query q : this.query) {
            stringBuilder.append(q.getStatement() + ",");
        }
        return stringBuilder.toString();
    }
}

