/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.ExecutionType;
import org.apache.phoenix.pherf.configuration.Query;
import org.apache.phoenix.pherf.configuration.QuerySet;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.WriteParams;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.result.DataModelResult;
import org.apache.phoenix.pherf.result.QueryResult;
import org.apache.phoenix.pherf.result.QuerySetResult;
import org.apache.phoenix.pherf.result.ResultManager;
import org.apache.phoenix.pherf.result.ScenarioResult;
import org.apache.phoenix.pherf.result.ThreadTime;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.MultiThreadedRunner;
import org.apache.phoenix.pherf.workload.MultithreadedDiffer;
import org.apache.phoenix.pherf.workload.QueryVerifier;
import org.apache.phoenix.pherf.workload.Workload;
import org.apache.phoenix.pherf.workload.WorkloadExecutor;
import org.apache.phoenix.pherf.workload.WriteWorkload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutor
implements Workload {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutor.class);
    private List<DataModel> dataModels;
    private String queryHint;
    private final boolean exportCSV;
    private final XMLConfigParser parser;
    private final PhoenixUtil util;
    private final WorkloadExecutor workloadExecutor;

    public QueryExecutor(XMLConfigParser parser, PhoenixUtil util, WorkloadExecutor workloadExecutor) {
        this(parser, util, workloadExecutor, parser.getDataModels(), null, false);
    }

    public QueryExecutor(XMLConfigParser parser, PhoenixUtil util, WorkloadExecutor workloadExecutor, List<DataModel> dataModels, String queryHint, boolean exportCSV) {
        this.parser = parser;
        this.queryHint = queryHint;
        this.exportCSV = exportCSV;
        this.dataModels = dataModels;
        this.util = util;
        this.workloadExecutor = workloadExecutor;
    }

    @Override
    public void complete() {
    }

    @Override
    public Runnable execute() throws Exception {
        Runnable runnable = null;
        for (DataModel dataModel : this.dataModels) {
            if (this.exportCSV) {
                runnable = this.exportAllScenarios(dataModel);
                continue;
            }
            runnable = this.executeAllScenarios(dataModel);
        }
        return runnable;
    }

    protected Runnable exportAllScenarios(final DataModel dataModel) throws Exception {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    List<Scenario> scenarios = dataModel.getScenarios();
                    QueryVerifier exportRunner = new QueryVerifier(false);
                    for (Scenario scenario : scenarios) {
                        for (QuerySet querySet : scenario.getQuerySet()) {
                            QueryExecutor.this.util.executeQuerySetDdls(querySet);
                            for (Query query : querySet.getQuery()) {
                                exportRunner.exportCSV(query);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn("", (Throwable)e);
                }
            }
        };
    }

    protected Runnable executeAllScenarios(final DataModel dataModel) throws Exception {
        return new Runnable(){

            @Override
            public void run() {
                ArrayList<DataModelResult> dataModelResults = new ArrayList<DataModelResult>();
                DataModelResult dataModelResult = new DataModelResult(dataModel, PhoenixUtil.getZookeeper());
                ResultManager resultManager = new ResultManager(dataModelResult.getName());
                dataModelResults.add(dataModelResult);
                List<Scenario> scenarios = dataModel.getScenarios();
                Configuration conf = HBaseConfiguration.create();
                Map phoenixProperty = conf.getValByRegex("phoenix");
                try {
                    for (Scenario scenario : scenarios) {
                        ScenarioResult scenarioResult = new ScenarioResult(scenario);
                        scenarioResult.setPhoenixProperties(phoenixProperty);
                        dataModelResult.getScenarioResult().add(scenarioResult);
                        WriteParams writeParams = scenario.getWriteParams();
                        if (writeParams != null) {
                            int writerThreadCount = writeParams.getWriterThreadCount();
                            for (int i = 0; i < writerThreadCount; ++i) {
                                logger.debug("Inserting write workload ( " + i + " ) of ( " + writerThreadCount + " )");
                                WriteWorkload writes = new WriteWorkload(PhoenixUtil.create(), QueryExecutor.this.parser, PherfConstants.GeneratePhoenixStats.NO);
                                QueryExecutor.this.workloadExecutor.add(writes);
                            }
                        }
                        for (QuerySet querySet : scenario.getQuerySet()) {
                            QuerySetResult querySetResult = new QuerySetResult(querySet);
                            scenarioResult.getQuerySetResult().add(querySetResult);
                            QueryExecutor.this.util.executeQuerySetDdls(querySet);
                            if (querySet.getExecutionType() == ExecutionType.SERIAL) {
                                QueryExecutor.this.executeQuerySetSerial(dataModelResult, querySet, querySetResult);
                                continue;
                            }
                            QueryExecutor.this.executeQuerySetParallel(dataModelResult, querySet, querySetResult);
                        }
                        resultManager.write(dataModelResult);
                    }
                    resultManager.write(dataModelResults);
                }
                catch (Exception e) {
                    logger.warn("", (Throwable)e);
                }
            }
        };
    }

    protected void executeQuerySetSerial(DataModelResult dataModelResult, QuerySet querySet, QuerySetResult querySetResult) throws InterruptedException {
        for (Query query : querySet.getQuery()) {
            QueryResult queryResult = new QueryResult(query);
            querySetResult.getQueryResults().add(queryResult);
            for (int cr = querySet.getMinConcurrency(); cr <= querySet.getMaxConcurrency(); ++cr) {
                ArrayList threads = new ArrayList();
                for (int i = 0; i < cr; ++i) {
                    Runnable runnable = this.executeRunner(i + 1 + "," + cr, dataModelResult, queryResult, querySetResult);
                    threads.add(this.workloadExecutor.getPool().submit(runnable));
                }
                for (Future future : threads) {
                    try {
                        future.get();
                    }
                    catch (ExecutionException e) {
                        logger.error("", (Throwable)e);
                    }
                }
            }
        }
    }

    protected void executeQuerySetParallel(DataModelResult dataModelResult, QuerySet querySet, QuerySetResult querySetResult) throws InterruptedException {
        for (int cr = querySet.getMinConcurrency(); cr <= querySet.getMaxConcurrency(); ++cr) {
            ArrayList threads = new ArrayList();
            for (int i = 0; i < cr; ++i) {
                for (Query query : querySet.getQuery()) {
                    QueryResult queryResult = new QueryResult(query);
                    querySetResult.getQueryResults().add(queryResult);
                    Runnable thread = this.executeRunner(i + 1 + "," + cr, dataModelResult, queryResult, querySetResult);
                    threads.add(this.workloadExecutor.getPool().submit(thread));
                }
                for (Future future : threads) {
                    try {
                        future.get();
                    }
                    catch (ExecutionException e) {
                        logger.error("", (Throwable)e);
                    }
                }
            }
        }
    }

    protected Runnable executeRunner(String name, DataModelResult dataModelResult, QueryResult queryResult, QuerySet querySet) {
        ThreadTime threadTime = new ThreadTime();
        queryResult.getThreadTimes().add(threadTime);
        threadTime.setThreadName(name);
        queryResult.setHint(this.queryHint);
        logger.info("\nExecuting query " + queryResult.getStatement());
        Runnable thread = this.workloadExecutor.isPerformance() ? new MultiThreadedRunner(threadTime.getThreadName(), queryResult, dataModelResult, threadTime, querySet.getNumberOfExecutions(), querySet.getExecutionDurationInMs()) : new MultithreadedDiffer(threadTime.getThreadName(), queryResult, threadTime, querySet.getNumberOfExecutions(), querySet.getExecutionDurationInMs());
        return thread;
    }
}

