/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.result.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.phoenix.pherf.result.DataModelResult;
import org.apache.phoenix.pherf.result.QueryResult;
import org.apache.phoenix.pherf.result.QuerySetResult;
import org.apache.phoenix.pherf.result.Result;
import org.apache.phoenix.pherf.result.ResultValue;
import org.apache.phoenix.pherf.result.RunTime;
import org.apache.phoenix.pherf.result.ScenarioResult;
import org.apache.phoenix.pherf.result.ThreadTime;
import org.apache.phoenix.pherf.result.file.ResultFileDetails;
import org.apache.phoenix.pherf.result.impl.DefaultResultHandler;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class ImageResultHandler
extends DefaultResultHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(Result result) throws Exception {
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        int rowCount = 0;
        int maxLegendCount = 20;
        int chartDimension = 1100;
        ResultValue resultValue = result.getResultValues().get(0);
        DataModelResult dataModelResult = (DataModelResult)resultValue.getResultValue();
        for (ScenarioResult scenarioResult : dataModelResult.getScenarioResult()) {
            for (QuerySetResult querySetResult : scenarioResult.getQuerySetResult()) {
                for (QueryResult queryResult : querySetResult.getQueryResults()) {
                    for (ThreadTime tt : queryResult.getThreadTimes()) {
                        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)(queryResult.getStatement() + " :: " + tt.getThreadName())));
                        ++rowCount;
                        List<RunTime> list = tt.getRunTimesInMs();
                        synchronized (list) {
                            for (RunTime rt : tt.getRunTimesInMs()) {
                                if (rt.getStartTime() == null) continue;
                                timeSeries.add((RegularTimePeriod)new Millisecond(rt.getStartTime()), (Number)rt.getElapsedDurationInMs());
                            }
                        }
                        timeSeriesCollection.addSeries(timeSeries);
                    }
                }
            }
        }
        boolean legend = rowCount <= maxLegendCount;
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)dataModelResult.getName(), (String)"Time", (String)"Query Time (ms)", (XYDataset)timeSeriesCollection, (boolean)legend, (boolean)true, (boolean)false);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(3);
        chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
        chart.getXYPlot().setBackgroundPaint((Paint)Color.WHITE);
        chart.getXYPlot().setRangeGridlinePaint((Paint)Color.BLACK);
        for (int i = 0; i < rowCount; ++i) {
            chart.getXYPlot().getRenderer().setSeriesStroke(i, (Stroke)new BasicStroke(3.0f));
        }
        try {
            ChartUtilities.saveChartAsJPEG((File)new File(this.resultFileName), (JFreeChart)chart, (int)chartDimension, (int)chartDimension);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void flush() throws Exception {
    }

    @Override
    public synchronized void close() throws Exception {
    }

    @Override
    public List<Result> read() throws Exception {
        return null;
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    @Override
    public void setResultFileDetails(ResultFileDetails details) {
        super.setResultFileDetails(ResultFileDetails.IMAGE);
    }
}

