/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.result;

import java.util.ArrayList;
import java.util.List;
import org.apache.phoenix.pherf.result.DataModelResult;
import org.apache.phoenix.pherf.result.ResultHandler;
import org.apache.phoenix.pherf.result.ResultUtil;
import org.apache.phoenix.pherf.result.file.ResultFileDetails;
import org.apache.phoenix.pherf.result.impl.CSVFileResultHandler;
import org.apache.phoenix.pherf.result.impl.ImageResultHandler;
import org.apache.phoenix.pherf.result.impl.XMLResultHandler;
import org.apache.phoenix.util.InstanceResolver;

public class ResultManager {
    private final List<ResultHandler> resultHandlers;
    private final ResultUtil util;
    private static final List<ResultHandler> defaultHandlers = new ArrayList<ResultHandler>();

    public ResultManager(String fileNameSeed) {
        this(fileNameSeed, InstanceResolver.get(ResultHandler.class, defaultHandlers));
    }

    public ResultManager(String fileNameSeed, List<ResultHandler> resultHandlers) {
        this.resultHandlers = resultHandlers;
        this.util = new ResultUtil();
        for (ResultHandler resultHandler : resultHandlers) {
            if (resultHandler.getResultFileName() != null) continue;
            resultHandler.setResultFileName(fileNameSeed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(DataModelResult result) throws Exception {
        try {
            this.util.ensureBaseResultDirExists();
            DataModelResult dataModelResultCopy = new DataModelResult(result);
            for (ResultHandler handler : this.resultHandlers) {
                this.util.write(handler, dataModelResultCopy);
            }
        }
        finally {
            for (ResultHandler handler : this.resultHandlers) {
                try {
                    if (handler == null) continue;
                    handler.flush();
                    handler.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(List<DataModelResult> dataModelResults) throws Exception {
        this.util.ensureBaseResultDirExists();
        CSVFileResultHandler detailsCSVWriter = null;
        try {
            detailsCSVWriter = new CSVFileResultHandler();
            detailsCSVWriter.setResultFileDetails(ResultFileDetails.CSV_DETAILED_PERFORMANCE);
            detailsCSVWriter.setResultFileName("COMBINED");
            for (DataModelResult dataModelResult : dataModelResults) {
                this.util.write(detailsCSVWriter, dataModelResult);
            }
        }
        finally {
            if (detailsCSVWriter != null) {
                detailsCSVWriter.flush();
                detailsCSVWriter.close();
            }
        }
    }

    public List<ResultHandler> getResultHandlers() {
        return this.resultHandlers;
    }

    static {
        XMLResultHandler xmlResultHandler = new XMLResultHandler();
        xmlResultHandler.setResultFileDetails(ResultFileDetails.XML);
        defaultHandlers.add(xmlResultHandler);
        ImageResultHandler imageResultHandler = new ImageResultHandler();
        imageResultHandler.setResultFileDetails(ResultFileDetails.IMAGE);
        defaultHandlers.add(imageResultHandler);
        CSVFileResultHandler handlerAgg = new CSVFileResultHandler();
        handlerAgg.setResultFileDetails(ResultFileDetails.CSV_AGGREGATE_PERFORMANCE);
        defaultHandlers.add(handlerAgg);
        CSVFileResultHandler handlerDet = new CSVFileResultHandler();
        handlerDet.setResultFileDetails(ResultFileDetails.CSV_DETAILED_PERFORMANCE);
        defaultHandlers.add(handlerDet);
    }
}

