/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.result;

import java.util.Arrays;
import java.util.List;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.result.DataModelResult;
import org.apache.phoenix.pherf.result.ResultHandler;
import org.apache.phoenix.pherf.result.ResultUtil;
import org.apache.phoenix.pherf.result.file.ResultFileDetails;
import org.apache.phoenix.pherf.result.impl.CSVResultHandler;
import org.apache.phoenix.pherf.result.impl.ImageResultHandler;
import org.apache.phoenix.pherf.result.impl.XMLResultHandler;

public class ResultManager {
    private final List<ResultHandler> resultHandlers;
    private final ResultUtil util;
    private final PherfConstants.RunMode runMode;

    public ResultManager(String fileNameSeed, PherfConstants.RunMode runMode) {
        this(runMode, Arrays.asList(new XMLResultHandler(fileNameSeed, ResultFileDetails.XML), new ImageResultHandler(fileNameSeed, ResultFileDetails.IMAGE), new CSVResultHandler(fileNameSeed, runMode == PherfConstants.RunMode.PERFORMANCE ? ResultFileDetails.CSV_DETAILED_PERFORMANCE : ResultFileDetails.CSV_DETAILED_FUNCTIONAL), new CSVResultHandler(fileNameSeed, ResultFileDetails.CSV_AGGREGATE_PERFORMANCE)));
    }

    public ResultManager(PherfConstants.RunMode runMode, List<ResultHandler> resultHandlers) {
        this.resultHandlers = resultHandlers;
        this.util = new ResultUtil();
        this.runMode = runMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(DataModelResult result) throws Exception {
        try {
            this.util.ensureBaseResultDirExists();
            DataModelResult dataModelResultCopy = new DataModelResult(result);
            for (ResultHandler handler : this.resultHandlers) {
                this.util.write(handler, dataModelResultCopy, this.runMode);
            }
        }
        finally {
            for (ResultHandler handler : this.resultHandlers) {
                try {
                    if (handler == null) continue;
                    handler.flush();
                    handler.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(List<DataModelResult> dataModelResults) throws Exception {
        this.util.ensureBaseResultDirExists();
        CSVResultHandler detailsCSVWriter = null;
        try {
            detailsCSVWriter = new CSVResultHandler("COMBINED", ResultFileDetails.CSV_DETAILED_PERFORMANCE);
            for (DataModelResult dataModelResult : dataModelResults) {
                this.util.write(detailsCSVWriter, dataModelResult, this.runMode);
            }
        }
        finally {
            if (detailsCSVWriter != null) {
                detailsCSVWriter.flush();
                detailsCSVWriter.close();
            }
        }
    }
}

