/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.ResultBaseTest;
import org.apache.phoenix.pherf.configuration.Query;
import org.apache.phoenix.pherf.jmx.MonitorManager;
import org.apache.phoenix.pherf.result.DataModelResult;
import org.apache.phoenix.pherf.result.QueryResult;
import org.apache.phoenix.pherf.result.QuerySetResult;
import org.apache.phoenix.pherf.result.Result;
import org.apache.phoenix.pherf.result.ResultManager;
import org.apache.phoenix.pherf.result.ResultValue;
import org.apache.phoenix.pherf.result.RunTime;
import org.apache.phoenix.pherf.result.ScenarioResult;
import org.apache.phoenix.pherf.result.ThreadTime;
import org.apache.phoenix.pherf.result.file.Extension;
import org.apache.phoenix.pherf.result.file.ResultFileDetails;
import org.apache.phoenix.pherf.result.impl.CSVResultHandler;
import org.apache.phoenix.pherf.result.impl.XMLResultHandler;
import org.junit.Assert;
import org.junit.Test;

public class ResultTest
extends ResultBaseTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMonitorWriter() throws Exception {
        String[] row = "org.apache.phoenix.pherf:type=PherfWriteThreads,6,Mon Jan 05 15:14:00 PST 2015".split(",");
        CSVResultHandler resultMonitorWriter = null;
        ArrayList<ResultValue> resultValues = new ArrayList<ResultValue>();
        for (String val : row) {
            resultValues.add(new ResultValue((Object)val));
        }
        try {
            resultMonitorWriter = new CSVResultHandler("STATS_MONITOR", ResultFileDetails.CSV_MONITOR);
            Result result = new Result(ResultFileDetails.CSV_MONITOR, ResultFileDetails.CSV_MONITOR.getHeader().toString(), resultValues);
            resultMonitorWriter.write(result);
            resultMonitorWriter.write(result);
            resultMonitorWriter.write(result);
            resultMonitorWriter.close();
            List results = resultMonitorWriter.read();
            Assert.assertEquals((String)"Results did not contain row.", (long)results.size(), (long)3L);
        }
        finally {
            if (resultMonitorWriter != null) {
                resultMonitorWriter.flush();
                resultMonitorWriter.close();
            }
        }
    }

    @Test
    public void testMonitorResult() throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        MonitorManager monitor = new MonitorManager(100L);
        Future<?> future = executorService.submit(monitor.execute());
        int TIMEOUT = 30;
        int ct = 0;
        int max = 30;
        while (!future.isDone()) {
            Thread.sleep(100L);
            if (ct == max) {
                monitor.complete();
                for (int timer = 0; monitor.isRunning() && timer < 30; ++timer) {
                    System.out.println("Waiting for monitor to finish. Seconds Waited :" + timer);
                    Thread.sleep(1000L);
                }
            }
            ++ct;
        }
        executorService.shutdown();
        List records = monitor.readResults();
        Assert.assertNotNull((String)"Could not retrieve records", (Object)records);
        Assert.assertTrue((String)"Failed to get correct CSV records.", (records.size() > 0 ? 1 : 0) != 0);
        Assert.assertFalse((String)"Monitor was not stopped correctly.", (boolean)monitor.isRunning());
    }

    @Test
    public void testExtensionEnum() {
        Assert.assertEquals((String)"Extension did not match", (Object)Extension.CSV.toString(), (Object)".csv");
        Assert.assertEquals((String)"Extension did not match", (Object)Extension.DETAILED_CSV.toString(), (Object)"_detail.csv");
    }

    @Test
    public void testResult() throws Exception {
        String filename = "testresult";
        XMLResultHandler xmlResultHandler = null;
        ResultManager resultManager = new ResultManager(filename, PherfConstants.RunMode.PERFORMANCE);
        DataModelResult dataModelResult = new DataModelResult();
        dataModelResult.setZookeeper("mytestzk");
        ScenarioResult scenarioResult = new ScenarioResult();
        scenarioResult.setTableName("MY_TABLE_NAME");
        dataModelResult.getScenarioResult().add(scenarioResult);
        scenarioResult.setRowCount(999);
        QuerySetResult querySetResult = new QuerySetResult();
        querySetResult.setConcurrency("50");
        scenarioResult.getQuerySetResult().add(querySetResult);
        Query query = new Query();
        Query query2 = new Query();
        query.setQueryGroup("g123");
        query.setTenantId("tennantID123");
        query.setStatement("Select    * \nfrom    FHA");
        query2.setStatement("Select a, b, c  * \nfrom    FHA2");
        Assert.assertEquals((String)"Expected consecutive spaces to be normalized", (Object)"Select * from FHA", (Object)query.getStatement());
        QueryResult queryResult = new QueryResult(query);
        QueryResult queryResult2 = new QueryResult(query2);
        querySetResult.getQueryResults().add(queryResult);
        querySetResult.getQueryResults().add(queryResult2);
        ThreadTime tt = new ThreadTime();
        tt.setThreadName("thread1");
        Calendar calendar = Calendar.getInstance();
        Date startTime1 = calendar.getTime();
        RunTime runtime1 = new RunTime(startTime1, Long.valueOf(1000L), Integer.valueOf(10));
        tt.getRunTimesInMs().add(runtime1);
        calendar.add(12, -1);
        RunTime runtime2 = new RunTime(calendar.getTime(), Long.valueOf(2000L), Integer.valueOf(20));
        tt.getRunTimesInMs().add(runtime2);
        calendar.add(12, -1);
        RunTime runtime3 = new RunTime(calendar.getTime(), Long.valueOf(3000L), Integer.valueOf(30));
        tt.getRunTimesInMs().add(runtime3);
        queryResult.getThreadTimes().add(tt);
        queryResult2.getThreadTimes().add(tt);
        resultManager.write(dataModelResult);
        ArrayList<DataModelResult> modelResults = new ArrayList<DataModelResult>();
        modelResults.add(dataModelResult);
        modelResults.add(dataModelResult);
        resultManager.write(modelResults);
        xmlResultHandler = new XMLResultHandler(filename, ResultFileDetails.XML);
        List resultList = xmlResultHandler.read();
        ResultValue resultValue = (ResultValue)((Result)resultList.get(0)).getResultValues().get(0);
        DataModelResult dataModelResultFromFile = (DataModelResult)resultValue.getResultValue();
        ScenarioResult scenarioResultFromFile = (ScenarioResult)dataModelResultFromFile.getScenarioResult().get(0);
        QuerySetResult querySetResultFromFile = (QuerySetResult)scenarioResultFromFile.getQuerySetResult().get(0);
        QueryResult queryResultFromFile = (QueryResult)querySetResultFromFile.getQueryResults().get(0);
        ThreadTime ttFromFile = (ThreadTime)queryResultFromFile.getThreadTimes().get(0);
        Assert.assertEquals((long)10L, (long)ttFromFile.getMinTimeInMs().getElapsedDurationInMs().intValue());
        Assert.assertEquals((long)30L, (long)ttFromFile.getMaxTimeInMs().getElapsedDurationInMs().intValue());
        Assert.assertEquals((long)20L, (long)ttFromFile.getAvgTimeInMs().intValue());
        Assert.assertEquals((Object)runtime3.getStartTime(), (Object)ttFromFile.getStartTime());
        Assert.assertEquals((Object)runtime1.getResultRowCount(), (Object)((RunTime)ttFromFile.getRunTimesInMs().get(0)).getResultRowCount());
        Assert.assertEquals((Object)runtime2.getResultRowCount(), (Object)((RunTime)ttFromFile.getRunTimesInMs().get(1)).getResultRowCount());
        Assert.assertEquals((Object)runtime3.getResultRowCount(), (Object)((RunTime)ttFromFile.getRunTimesInMs().get(2)).getResultRowCount());
        Assert.assertEquals((long)10L, (long)queryResultFromFile.getAvgMinRunTimeInMs());
        Assert.assertEquals((long)30L, (long)queryResultFromFile.getAvgMaxRunTimeInMs());
        Assert.assertEquals((long)20L, (long)queryResultFromFile.getAvgRunTimeInMs());
        Assert.assertEquals((Object)runtime3.getStartTime(), (Object)queryResultFromFile.getStartTime());
    }
}

