/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload;

import java.util.Calendar;
import java.util.Date;
import org.apache.phoenix.pherf.configuration.Query;
import org.apache.phoenix.pherf.result.RunTime;
import org.apache.phoenix.pherf.result.ThreadTime;
import org.apache.phoenix.pherf.workload.MultiThreadedRunner;
import org.apache.phoenix.pherf.workload.QueryVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MultithreadedDiffer
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MultiThreadedRunner.class);
    private Thread t;
    private Query query;
    private ThreadTime threadTime;
    private long numberOfExecutions;
    private long executionDurationInMs;
    private QueryVerifier queryVerifier = new QueryVerifier(true);

    private synchronized ThreadTime getThreadTime() {
        return this.threadTime;
    }

    private void diffQuery() throws Exception {
        Long start = System.currentTimeMillis();
        Date startDate = Calendar.getInstance().getTime();
        String newCSV = this.queryVerifier.exportCSV(this.query);
        boolean verifyResult = this.queryVerifier.doDiff(this.query, newCSV);
        String explainPlan = this.queryVerifier.getExplainPlan(this.query);
        this.getThreadTime().getRunTimesInMs().add(new RunTime(verifyResult ? "VERIFIED_DIFF" : "FAILED_DIFF", explainPlan, startDate, -1L, (int)(System.currentTimeMillis() - start)));
    }

    MultithreadedDiffer(String threadName, Query query, ThreadTime threadTime, long numberOfExecutions, long executionDurationInMs) {
        this.query = query;
        this.threadTime = threadTime;
        this.numberOfExecutions = numberOfExecutions;
        this.executionDurationInMs = executionDurationInMs;
    }

    @Override
    public void run() {
        logger.info("\n\nThread Starting " + this.t.getName() + " ; " + this.query.getStatement() + " for " + this.numberOfExecutions + "times\n\n");
        Long start = System.currentTimeMillis();
        for (long i = this.numberOfExecutions; i > 0L && System.currentTimeMillis() - start < this.executionDurationInMs; --i) {
            try {
                this.diffQuery();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.info("\n\nThread exiting." + this.t.getName() + "\n\n");
    }
}

