/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.rules;

import com.google.common.base.Preconditions;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.DataSequence;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.rules.DataValue;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesApplier {
    private static final Logger logger = LoggerFactory.getLogger(RulesApplier.class);
    private static final AtomicLong COUNTER = new AtomicLong(100L);
    private static final int OH_SHIT_LIMIT = 1000;
    private final Random rndNull;
    private final Random rndVal;
    private final RandomDataGenerator randomDataGenerator;
    private final XMLConfigParser parser;
    private final List<Map> modelList;

    public RulesApplier(XMLConfigParser parser) {
        this(parser, System.currentTimeMillis());
    }

    public RulesApplier(XMLConfigParser parser, long seed) {
        this.parser = parser;
        this.modelList = new ArrayList<Map>();
        this.rndNull = new Random(seed);
        this.rndVal = new Random(seed);
        this.randomDataGenerator = new RandomDataGenerator();
        this.populateModelList();
    }

    public List<Map> getModelList() {
        return Collections.unmodifiableList(this.modelList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataValue getDataForRule(Scenario scenario, Column phxMetaColumn) throws Exception {
        List<Scenario> scenarios = this.parser.getScenarios();
        DataValue value = null;
        if (scenarios.contains(scenario)) {
            logger.debug("We found a correct Scenario");
            Map ruleMap = this.modelList.get(0);
            List ruleList = (List)ruleMap.get((Object)phxMetaColumn.getType());
            if (ruleList.contains(phxMetaColumn)) {
                logger.debug("We found a correct column rule");
                Column columnRule = this.getColumnForRule(ruleList, phxMetaColumn);
                DataValue dataValue = value = this.getDataValue(columnRule);
                synchronized (dataValue) {
                    if (columnRule.getPrefix() != null) {
                        value.setValue(columnRule.getPrefix() + value.getValue());
                    }
                }
            } else {
                logger.warn("Attempted to apply rule to data, but could not find a rule to match type:" + (Object)((Object)phxMetaColumn.getType()));
            }
        }
        return value;
    }

    public DataValue getDataValue(Column column) throws Exception {
        DataValue data = null;
        int length = column.getLength();
        int nullChance = column.getNullChance();
        List<DataValue> dataValues = column.getDataValues();
        if (nullChance != Integer.MIN_VALUE && this.isValueNull(nullChance)) {
            return new DataValue(column.getType(), "");
        }
        switch (column.getType()) {
            case VARCHAR: {
                if (column.getDataValues() != null && column.getDataValues().size() > 0) {
                    data = this.generateDataValue(dataValues);
                    break;
                }
                Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"length needs to be > 0");
                if (column.getDataSequence() == DataSequence.SEQUENTIAL) {
                    data = this.getSequentialDataValue(column);
                    break;
                }
                String varchar = RandomStringUtils.randomAlphanumeric((int)length);
                data = new DataValue(column.getType(), varchar);
                break;
            }
            case CHAR: {
                if (column.getDataValues() != null && column.getDataValues().size() > 0) {
                    data = this.generateDataValue(dataValues);
                    break;
                }
                Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"length needs to be > 0");
                if (column.getDataSequence() == DataSequence.SEQUENTIAL) {
                    data = this.getSequentialDataValue(column);
                    break;
                }
                String varchar = RandomStringUtils.randomAlphanumeric((int)length);
                data = new DataValue(column.getType(), varchar);
                break;
            }
            case DECIMAL: {
                if (column.getDataValues() != null && column.getDataValues().size() > 0) {
                    data = this.generateDataValue(dataValues);
                    break;
                }
                int precision = column.getPrecision();
                double minDbl = column.getMinValue();
                Preconditions.checkArgument((precision > 0 && precision <= 18 ? 1 : 0) != 0, (Object)"Precision must be between 0 and 18");
                Preconditions.checkArgument((minDbl >= 0.0 ? 1 : 0) != 0, (Object)"minvalue must be set in configuration");
                Preconditions.checkArgument((column.getMaxValue() > 0 ? 1 : 0) != 0, (Object)"maxValue must be set in configuration");
                StringBuilder maxValueStr = new StringBuilder();
                for (int i = 0; i < precision; ++i) {
                    maxValueStr.append(9);
                }
                double maxDbl = Math.min((double)column.getMaxValue(), Double.parseDouble(maxValueStr.toString()));
                double dbl = RandomUtils.nextDouble((double)minDbl, (double)maxDbl);
                data = new DataValue(column.getType(), String.valueOf(dbl));
                break;
            }
            case INTEGER: {
                if (column.getDataValues() != null && column.getDataValues().size() > 0) {
                    data = this.generateDataValue(dataValues);
                    break;
                }
                int minInt = column.getMinValue();
                int maxInt = column.getMaxValue();
                Preconditions.checkArgument((minInt > 0 && maxInt > 0 ? 1 : 0) != 0, (Object)"min and max values need to be set in configuration");
                int intVal = RandomUtils.nextInt((int)minInt, (int)maxInt);
                data = new DataValue(column.getType(), String.valueOf(intVal));
                break;
            }
            case DATE: {
                if (column.getDataValues() != null && column.getDataValues().size() > 0) {
                    data = this.generateDataValue(dataValues);
                    break;
                }
                int minYear = column.getMinValue();
                int maxYear = column.getMaxValue();
                Preconditions.checkArgument((minYear > 0 && maxYear > 0 ? 1 : 0) != 0, (Object)"min and max values need to be set in configuration");
                String dt = this.generateRandomDate(minYear, maxYear);
                data = new DataValue(column.getType(), dt);
                break;
            }
        }
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"Data value could not be generated for some reason. Please check configs");
        return data;
    }

    public String generateRandomDate(int min, int max) {
        int year = RandomUtils.nextInt((int)min, (int)max);
        int month = RandomUtils.nextInt((int)0, (int)11);
        int day = RandomUtils.nextInt((int)0, (int)31);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
        return df.format(calendar.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateRandomDate(String min, String max) throws Exception {
        DateTime dt;
        DateTimeFormatter fmtr = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS");
        DateTime minDt = fmtr.parseDateTime(min);
        DateTime maxDt = fmtr.parseDateTime(max);
        RandomDataGenerator randomDataGenerator = this.randomDataGenerator;
        synchronized (randomDataGenerator) {
            long rndLong = this.randomDataGenerator.nextLong(minDt.getMillis(), maxDt.getMillis());
            dt = new DateTime(rndLong, minDt.getZone());
        }
        return fmtr.print((ReadableInstant)dt);
    }

    private boolean isValueNull(int chance) {
        return this.rndNull.nextInt(100) < chance;
    }

    private DataValue generateDataValue(List<DataValue> values) throws Exception {
        DataValue generatedDataValue = null;
        int sum = 0;
        int count = 0;
        for (DataValue value : values) {
            int dist = value.getDistribution();
            sum += dist;
        }
        Preconditions.checkArgument((sum == 100 || sum == 0 ? 1 : 0) != 0, (Object)"Distributions need to add up to 100 or not exist.");
        while (generatedDataValue == null) {
            int rndIndex = this.rndVal.nextInt(values.size());
            DataValue valueRule = values.get(rndIndex);
            generatedDataValue = this.generateDataValue(valueRule);
            if (count++ != 1000) continue;
            logger.info("We generated a value from hitting our OH_SHIT_LIMIT: 1000");
            generatedDataValue = valueRule;
        }
        return generatedDataValue;
    }

    private DataValue generateDataValue(DataValue valueRule) throws Exception {
        DataValue retValue = new DataValue(valueRule);
        if (valueRule.getValue() != null) {
            int chance = valueRule.getDistribution() == 0 ? 100 : valueRule.getDistribution();
            return this.rndVal.nextInt(100) <= chance ? retValue : null;
        }
        Preconditions.checkArgument((retValue.getMinValue() != null || retValue.getMaxValue() != null ? 1 : 0) != 0, (Object)"Both min/maxValue tags must be set if value tag is not used");
        Preconditions.checkArgument((retValue.getType() == DataTypeMapping.DATE ? 1 : 0) != 0, (Object)"Currently on DATE is supported for ranged random values");
        retValue.setValue(this.generateRandomDate(retValue.getMinValue(), retValue.getMaxValue()));
        return retValue;
    }

    private void populateModelList() {
        if (!this.modelList.isEmpty()) {
            return;
        }
        for (DataModel model : this.parser.getDataModels()) {
            HashMap ruleMap = new HashMap();
            for (Column column : model.getDataMappingColumns()) {
                DataTypeMapping type = column.getType();
                if (ruleMap.containsKey((Object)type)) {
                    ((List)ruleMap.get((Object)type)).add(column);
                    continue;
                }
                LinkedList<Column> cols = new LinkedList<Column>();
                cols.add(column);
                ruleMap.put(type, cols);
            }
            this.modelList.add(ruleMap);
        }
    }

    private Column getColumnForRule(List<Column> ruleList, Column phxMetaColumn) {
        Column ruleAppliedColumn = new Column(ruleList.get(0));
        for (Column columnRule : ruleList) {
            if (columnRule.isUserDefined() && !columnRule.getName().equals(phxMetaColumn.getName())) continue;
            ruleAppliedColumn.mutate(columnRule);
        }
        return ruleAppliedColumn;
    }

    private DataValue getSequentialDataValue(Column column) {
        DataValue data = null;
        long inc = COUNTER.getAndIncrement();
        String strInc = String.valueOf(inc);
        String varchar = RandomStringUtils.randomAlphanumeric((int)(column.getLength() - strInc.length()));
        data = new DataValue(column.getType(), strInc + varchar);
        return data;
    }
}

