/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.result.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.result.DataModelResult;
import org.apache.phoenix.pherf.result.Result;
import org.apache.phoenix.pherf.result.ResultHandler;
import org.apache.phoenix.pherf.result.ResultUtil;
import org.apache.phoenix.pherf.result.ResultValue;
import org.apache.phoenix.pherf.result.file.ResultFileDetails;

public class XMLResultHandler
implements ResultHandler {
    private final String resultFileName;
    private final ResultFileDetails resultFileDetails;

    public XMLResultHandler(String resultFileName, ResultFileDetails resultFileDetails) {
        this(resultFileName, resultFileDetails, true);
    }

    public XMLResultHandler(String resultFileName, ResultFileDetails resultFileDetails, boolean generateFullFileName) {
        ResultUtil util = new ResultUtil();
        PherfConstants constants = PherfConstants.create();
        String resultDir = constants.getProperty("pherf.default.results.dir");
        this.resultFileName = generateFullFileName ? resultDir + "/" + "RESULT_" + resultFileName + util.getSuffix() + resultFileDetails.getExtension().toString() : resultFileName;
        this.resultFileDetails = resultFileDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(Result result) throws Exception {
        FileOutputStream os = null;
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DataModelResult.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        try {
            os = new FileOutputStream(this.resultFileName);
            ResultValue resultValue = result.getResultValues().get(0);
            jaxbMarshaller.marshal(resultValue.getResultValue(), (OutputStream)os);
        }
        finally {
            if (os != null) {
                os.flush();
                os.close();
            }
        }
    }

    @Override
    public synchronized void flush() throws IOException {
    }

    @Override
    public synchronized void close() throws IOException {
    }

    @Override
    public synchronized List<Result> read() throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DataModelResult.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        File XMLfile = new File(this.resultFileName);
        ArrayList<ResultValue> resultValue = new ArrayList<ResultValue>();
        resultValue.add(new ResultValue<DataModelResult>((DataModelResult)jaxbUnmarshaller.unmarshal(XMLfile)));
        ArrayList<Result> results = new ArrayList<Result>();
        results.add(new Result(ResultFileDetails.XML, null, resultValue));
        return results;
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    @Override
    public ResultFileDetails getResultFileDetails() {
        return this.resultFileDetails;
    }
}

