/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.phoenix.pherf.exception.FileLoaderRuntimeException;
import org.apache.phoenix.pherf.jmx.MonitorDetails;
import org.apache.phoenix.pherf.jmx.monitors.Monitor;
import org.apache.phoenix.pherf.result.Result;
import org.apache.phoenix.pherf.result.ResultHandler;
import org.apache.phoenix.pherf.result.ResultValue;
import org.apache.phoenix.pherf.result.file.ResultFileDetails;
import org.apache.phoenix.pherf.result.impl.CSVResultHandler;
import org.apache.phoenix.pherf.workload.Workload;
import org.apache.phoenix.util.DateUtil;

public class MonitorManager
implements Workload {
    private static final List<MonitorDetails> MONITOR_DETAILS_LIST = Arrays.asList(MonitorDetails.values());
    private final ResultHandler resultHandler;
    private final AtomicLong monitorFrequency;
    private final AtomicLong rowCount;
    private final AtomicBoolean shouldStop = new AtomicBoolean(false);
    private final AtomicBoolean isRunning = new AtomicBoolean(false);

    public MonitorManager() throws Exception {
        this(5000L);
    }

    public MonitorManager(long monitorFrequency) throws Exception {
        this.monitorFrequency = new AtomicLong(monitorFrequency);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        for (MonitorDetails monitorDetails : MONITOR_DETAILS_LIST) {
            StandardMBean bean = new StandardMBean(monitorDetails.getMonitor(), Monitor.class);
            ObjectName monitorThreadStatName = new ObjectName(monitorDetails.toString());
            try {
                mbs.registerMBean(bean, monitorThreadStatName);
            }
            catch (InstanceAlreadyExistsException e) {
                mbs.unregisterMBean(monitorThreadStatName);
                mbs.registerMBean(bean, monitorThreadStatName);
            }
        }
        this.rowCount = new AtomicLong(0L);
        this.resultHandler = new CSVResultHandler("STATS_MONITOR", ResultFileDetails.CSV);
    }

    @Override
    public synchronized void complete() {
        this.shouldStop.set(true);
    }

    @Override
    public Runnable execute() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    while (!MonitorManager.this.shouldStop()) {
                        MonitorManager.this.isRunning.set(true);
                        ArrayList<ResultValue> rowValues = new ArrayList<ResultValue>();
                        ResultHandler resultHandler = MonitorManager.this.resultHandler;
                        synchronized (resultHandler) {
                            for (MonitorDetails monitorDetails : MONITOR_DETAILS_LIST) {
                                rowValues.clear();
                                try {
                                    StandardMBean bean = new StandardMBean(monitorDetails.getMonitor(), Monitor.class);
                                    GregorianCalendar calendar = new GregorianCalendar();
                                    rowValues.add((ResultValue)((Object)monitorDetails));
                                    rowValues.add((ResultValue)((Object)((Monitor)bean.getImplementation()).getStat()));
                                    rowValues.add((ResultValue)((Object)DateUtil.DEFAULT_MS_DATE_FORMATTER.format(calendar.getTime())));
                                    Result result = new Result(ResultFileDetails.CSV, ResultFileDetails.CSV_MONITOR.getHeader().toString(), rowValues);
                                    MonitorManager.this.resultHandler.write(result);
                                }
                                catch (Exception e) {
                                    throw new FileLoaderRuntimeException("Could not log monitor result.", e);
                                }
                                MonitorManager.this.rowCount.getAndIncrement();
                            }
                            try {
                                MonitorManager.this.resultHandler.flush();
                                Thread.sleep(MonitorManager.this.getMonitorFrequency());
                            }
                            catch (Exception e) {
                                Thread.currentThread().interrupt();
                                e.printStackTrace();
                            }
                        }
                    }
                    return;
                }
                finally {
                    try {
                        MonitorManager.this.isRunning.set(false);
                        if (MonitorManager.this.resultHandler != null) {
                            MonitorManager.this.resultHandler.close();
                        }
                    }
                    catch (Exception e) {
                        throw new FileLoaderRuntimeException("Could not close monitor results.", e);
                    }
                }
            }
        };
    }

    public long getMonitorFrequency() {
        return this.monitorFrequency.get();
    }

    public boolean shouldStop() {
        return this.shouldStop.get();
    }

    public long getRowCount() {
        return this.rowCount.get();
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    public synchronized List<Result> readResults() throws Exception {
        try (ResultHandler handler = null;){
            if (this.resultHandler.isClosed()) {
                handler = new CSVResultHandler("STATS_MONITOR", ResultFileDetails.CSV);
                List<Result> list = handler.read();
                return list;
            }
            List<Result> list = this.resultHandler.read();
            return list;
        }
    }
}

