/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.result.impl;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.result.Result;
import org.apache.phoenix.pherf.result.ResultHandler;
import org.apache.phoenix.pherf.result.ResultUtil;
import org.apache.phoenix.pherf.result.ResultValue;
import org.apache.phoenix.pherf.result.file.ResultFileDetails;

public class CSVResultHandler
implements ResultHandler {
    private final ResultUtil util = new ResultUtil();
    private final ResultFileDetails resultFileDetails;
    private final String resultFileName;
    private volatile CSVPrinter csvPrinter = null;
    private volatile boolean isClosed = true;

    public CSVResultHandler(String resultFileName, ResultFileDetails resultFileDetails) {
        this(resultFileName, resultFileDetails, true);
    }

    public CSVResultHandler(String resultFileName, ResultFileDetails resultFileDetails, boolean generateFullFileName) {
        PherfConstants constants = PherfConstants.create();
        String resultDir = constants.getProperty("pherf.default.results.dir");
        this.resultFileName = generateFullFileName ? resultDir + "/" + "RESULT_" + resultFileName + this.util.getSuffix() + resultFileDetails.getExtension().toString() : resultFileName;
        this.resultFileDetails = resultFileDetails;
    }

    @Override
    public synchronized void write(Result result) throws IOException {
        this.util.ensureBaseResultDirExists();
        this.open(result);
        this.csvPrinter.printRecord(result.getResultValues());
        this.flush();
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.csvPrinter != null) {
            this.csvPrinter.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.csvPrinter != null) {
            this.csvPrinter.flush();
            this.csvPrinter.close();
            this.isClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<Result> read() throws IOException {
        this.util.ensureBaseResultDirExists();
        try (CSVParser parser = null;){
            File file = new File(this.resultFileName);
            parser = CSVParser.parse((File)file, (Charset)Charset.defaultCharset(), (CSVFormat)CSVFormat.DEFAULT);
            List records = parser.getRecords();
            ArrayList<Result> results = new ArrayList<Result>();
            String header = null;
            for (CSVRecord record : records) {
                if (record.getRecordNumber() == 1L) {
                    header = record.toString();
                    continue;
                }
                ArrayList<ResultValue> resultValues = new ArrayList<ResultValue>();
                for (String val : record.toString().split(",")) {
                    resultValues.add(new ResultValue<String>(val));
                }
                Result result = new Result(this.resultFileDetails, header, resultValues);
                results.add(result);
            }
            ArrayList<Result> arrayList = results;
            return arrayList;
        }
    }

    private void open(Result result) throws IOException {
        if (this.csvPrinter != null) {
            return;
        }
        this.csvPrinter = new CSVPrinter((Appendable)new PrintWriter(this.resultFileName), CSVFormat.DEFAULT);
        Object[] records = result.getHeader().split(",");
        this.csvPrinter.printRecord(records);
        this.isClosed = false;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public ResultFileDetails getResultFileDetails() {
        return this.resultFileDetails;
    }
}

