/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.phoenix.pherf.configuration.DataOverride;
import org.apache.phoenix.pherf.configuration.QuerySet;
import org.apache.phoenix.pherf.configuration.WriteParams;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.util.PhoenixUtil;

@XmlRootElement(namespace="org.apache.phoenix.pherf.configuration.DataModel")
public class Scenario {
    private String tableName;
    private int rowCount;
    private Map<String, String> phoenixProperties;
    private DataOverride dataOverride;
    private List<QuerySet> querySet = new ArrayList<QuerySet>();
    private WriteParams writeParams = new WriteParams();
    private String name;

    public boolean equals(Object object) {
        Scenario scenario = (Scenario)object;
        return this.tableName.equals(scenario.getTableName());
    }

    public int hashCode() {
        return new HashCodeBuilder(11, 38).appendSuper(super.hashCode()).append((Object)this.tableName).toHashCode();
    }

    @XmlAttribute
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @XmlAttribute
    public int getRowCount() {
        return PhoenixUtil.getRowCountOverride() == 0 ? this.rowCount : PhoenixUtil.getRowCountOverride();
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public Map<String, String> getPhoenixProperties() {
        return this.phoenixProperties;
    }

    public void setPhoenixProperties(Map<String, String> phoenixProperty) {
        this.phoenixProperties = phoenixProperty;
    }

    @XmlElement
    public DataOverride getDataOverride() {
        return this.dataOverride;
    }

    public void setDataOverride(DataOverride dataOverride) {
        this.dataOverride = dataOverride;
    }

    public List<QuerySet> getQuerySet() {
        return this.querySet;
    }

    public void setQuerySet(List<QuerySet> querySet) {
        this.querySet = querySet;
    }

    public String getSchemaName() {
        return XMLConfigParser.parseSchemaName(this.tableName);
    }

    public String getTableNameWithoutSchemaName() {
        return XMLConfigParser.parseTableName(this.tableName);
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WriteParams getWriteParams() {
        return this.writeParams;
    }

    public void setWriteParams(WriteParams writeParams) {
        this.writeParams = writeParams;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Name:" + this.name);
        stringBuilder.append("Table Name:" + this.tableName);
        stringBuilder.append("Row Count:" + this.rowCount);
        stringBuilder.append("Data Override:" + this.dataOverride);
        for (QuerySet query : this.querySet) {
            stringBuilder.append(query + ";");
        }
        return stringBuilder.toString();
    }
}

