/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.jmx.MonitorManager;
import org.apache.phoenix.pherf.loaddata.DataLoader;
import org.apache.phoenix.pherf.util.ResourceList;
import org.apache.phoenix.pherf.workload.QueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkloadExecutor {
    private static final Logger logger = LoggerFactory.getLogger(WorkloadExecutor.class);
    private final XMLConfigParser parser;
    private MonitorManager monitor;
    private Future monitorThread;
    private final int poolSize;
    private final ExecutorService pool;

    public WorkloadExecutor() throws Exception {
        this(new ResourceList().getProperties());
    }

    public WorkloadExecutor(Properties properties) throws Exception {
        this(properties, ".*scenario.xml");
    }

    public WorkloadExecutor(Properties properties, String filePattern) throws Exception {
        this(properties, new XMLConfigParser(filePattern), true);
    }

    public WorkloadExecutor(Properties properties, XMLConfigParser parser, boolean monitor) throws Exception {
        this.parser = parser;
        this.poolSize = properties.getProperty("pherf.default.threadpool") == null ? 10 : Integer.parseInt(properties.getProperty("pherf.default.threadpool"));
        this.pool = Executors.newFixedThreadPool(this.poolSize);
        if (monitor) {
            this.initMonitor(Integer.parseInt(properties.getProperty("pherf.default.monitorFrequency")));
        }
    }

    public void executeDataLoad() throws Exception {
        logger.info("\n\nStarting Data Loader...");
        DataLoader dataLoader = new DataLoader(this.parser);
        dataLoader.execute();
    }

    public void executeMultithreadedQueryExecutor(String queryHint, boolean export, PherfConstants.RunMode runMode) throws Exception {
        logger.info("\n\nStarting Query Executor...");
        QueryExecutor queryExecutor = new QueryExecutor(this.parser);
        queryExecutor.execute(queryHint, export, runMode);
    }

    public void shutdown() throws Exception {
        if (null != this.monitor && this.monitor.isRunning()) {
            this.monitor.stop();
            this.monitorThread.get(60L, TimeUnit.SECONDS);
            this.pool.shutdown();
        }
    }

    public XMLConfigParser getParser() {
        return this.parser;
    }

    private void initMonitor(int monitorFrequency) throws Exception {
        this.monitor = new MonitorManager(monitorFrequency);
        this.monitorThread = this.pool.submit(this.monitor);
    }
}

