/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.ExecutionType;
import org.apache.phoenix.pherf.configuration.Query;
import org.apache.phoenix.pherf.configuration.QuerySet;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.result.DataModelResult;
import org.apache.phoenix.pherf.result.QueryResult;
import org.apache.phoenix.pherf.result.QuerySetResult;
import org.apache.phoenix.pherf.result.ResultManager;
import org.apache.phoenix.pherf.result.ScenarioResult;
import org.apache.phoenix.pherf.result.ThreadTime;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.MultithreadedDiffer;
import org.apache.phoenix.pherf.workload.MultithreadedRunner;
import org.apache.phoenix.pherf.workload.QueryVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutor {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutor.class);
    private List<DataModel> dataModels;
    private String queryHint;
    private PherfConstants.RunMode runMode;

    public QueryExecutor(XMLConfigParser parser) {
        this.dataModels = parser.getDataModels();
    }

    public void execute(String queryHint, boolean exportCSV, PherfConstants.RunMode runMode) throws Exception {
        this.queryHint = queryHint;
        this.runMode = runMode;
        for (DataModel dataModel : this.dataModels) {
            if (exportCSV) {
                this.exportAllScenarios(dataModel);
                continue;
            }
            this.executeAllScenarios(dataModel);
        }
    }

    protected void exportAllScenarios(DataModel dataModel) throws Exception {
        List<Scenario> scenarios = dataModel.getScenarios();
        QueryVerifier exportRunner = new QueryVerifier(false);
        for (Scenario scenario : scenarios) {
            for (QuerySet querySet : scenario.getQuerySet()) {
                this.executeQuerySetDdls(querySet);
                for (Query query : querySet.getQuery()) {
                    exportRunner.exportCSV(query);
                }
            }
        }
    }

    protected void executeAllScenarios(DataModel dataModel) throws Exception {
        ArrayList<DataModelResult> dataModelResults = new ArrayList<DataModelResult>();
        DataModelResult dataModelResult = new DataModelResult(dataModel, PhoenixUtil.getZookeeper());
        ResultManager resultManager = new ResultManager(dataModelResult.getName(), this.runMode);
        dataModelResults.add(dataModelResult);
        List<Scenario> scenarios = dataModel.getScenarios();
        Configuration conf = HBaseConfiguration.create();
        Map phoenixProperty = conf.getValByRegex("phoenix");
        phoenixProperty.putAll(conf.getValByRegex("sfdc"));
        for (Scenario scenario : scenarios) {
            ScenarioResult scenarioResult = new ScenarioResult(scenario);
            scenarioResult.setPhoenixProperties(phoenixProperty);
            dataModelResult.getScenarioResult().add(scenarioResult);
            for (QuerySet querySet : scenario.getQuerySet()) {
                QuerySetResult querySetResult = new QuerySetResult(querySet);
                scenarioResult.getQuerySetResult().add(querySetResult);
                this.executeQuerySetDdls(querySet);
                if (querySet.getExecutionType() == ExecutionType.SERIAL) {
                    this.execcuteQuerySetSerial(dataModelResult, querySet, querySetResult, scenarioResult);
                    continue;
                }
                this.execcuteQuerySetParallel(dataModelResult, querySet, querySetResult, scenarioResult);
            }
            resultManager.write(dataModelResult);
        }
        resultManager.write(dataModelResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeQuerySetDdls(QuerySet querySet) throws Exception {
        PhoenixUtil pUtil = new PhoenixUtil();
        for (Query query : querySet.getQuery()) {
            if (null == query.getDdl()) continue;
            Connection conn = null;
            try {
                logger.info("\nExecuting DDL:" + query.getDdl() + " on tenantId:" + query.getTenantId());
                conn = pUtil.getConnection(query.getTenantId());
                pUtil.executeStatement(query.getDdl(), conn);
            }
            finally {
                if (null == conn) continue;
                conn.close();
            }
        }
    }

    protected void execcuteQuerySetSerial(DataModelResult dataModelResult, QuerySet querySet, QuerySetResult querySetResult, Scenario scenario) throws InterruptedException {
        for (Query query : querySet.getQuery()) {
            QueryResult queryResult = new QueryResult(query);
            querySetResult.getQueryResults().add(queryResult);
            for (int cr = querySet.getMinConcurrency(); cr <= querySet.getMaxConcurrency(); ++cr) {
                ArrayList<Thread> threads = new ArrayList<Thread>();
                for (int i = 0; i < cr; ++i) {
                    Thread thread = this.executeRunner(i + 1 + "," + cr, dataModelResult, queryResult, querySetResult);
                    threads.add(thread);
                }
                for (Thread thread : threads) {
                    thread.join();
                }
            }
        }
    }

    protected void execcuteQuerySetParallel(DataModelResult dataModelResult, QuerySet querySet, QuerySetResult querySetResult, Scenario scenario) throws InterruptedException {
        for (int cr = querySet.getMinConcurrency(); cr <= querySet.getMaxConcurrency(); ++cr) {
            ArrayList<Thread> threads = new ArrayList<Thread>();
            for (int i = 0; i < cr; ++i) {
                for (Query query : querySet.getQuery()) {
                    QueryResult queryResult = new QueryResult(query);
                    querySetResult.getQueryResults().add(queryResult);
                    Thread thread = this.executeRunner(i + 1 + "," + cr, dataModelResult, queryResult, querySetResult);
                    threads.add(thread);
                }
            }
            for (Thread thread : threads) {
                thread.join();
            }
        }
    }

    protected Thread executeRunner(String name, DataModelResult dataModelResult, QueryResult queryResult, QuerySet querySet) {
        ThreadTime threadTime = new ThreadTime();
        queryResult.getThreadTimes().add(threadTime);
        threadTime.setThreadName(name);
        queryResult.setHint(this.queryHint);
        logger.info("\nExecuting query " + queryResult.getStatement());
        Thread thread = this.runMode == PherfConstants.RunMode.FUNCTIONAL ? new MultithreadedDiffer(threadTime.getThreadName(), queryResult, threadTime, querySet.getNumberOfExecutions(), querySet.getExecutionDurationInMs()).start() : new MultithreadedRunner(threadTime.getThreadName(), queryResult, dataModelResult, threadTime, querySet.getNumberOfExecutions(), querySet.getExecutionDurationInMs()).start();
        return thread;
    }
}

