/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload;

import difflib.DiffUtils;
import difflib.Patch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.phoenix.pherf.configuration.Query;
import org.apache.phoenix.pherf.result.file.Extension;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryVerifier {
    private PhoenixUtil pUtil = new PhoenixUtil();
    private static final Logger logger = LoggerFactory.getLogger(QueryVerifier.class);
    private boolean useTemporaryOutput;
    private String directoryLocation;

    public QueryVerifier(boolean useTemporaryOutput) {
        this.useTemporaryOutput = useTemporaryOutput;
        this.directoryLocation = this.useTemporaryOutput ? "CSV_EXPORT_TMP" : "CSV_EXPORT";
        this.ensureBaseDirExists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportCSV(Query query) throws Exception {
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        String fileName = this.getFileName(query);
        FileOutputStream fos = new FileOutputStream(fileName);
        try {
            conn = this.pUtil.getConnection(query.getTenantId());
            statement = conn.prepareStatement(query.getStatement());
            boolean isQuery = statement.execute();
            if (isQuery) {
                rs = statement.executeQuery();
                int columnCount = rs.getMetaData().getColumnCount();
                while (rs.next()) {
                    for (int columnNum = 1; columnNum <= columnCount; ++columnNum) {
                        fos.write((rs.getString(columnNum) + ",").getBytes());
                    }
                    fos.write("\n".getBytes());
                }
            } else {
                conn.commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
            fos.flush();
            fos.close();
        }
        return fileName;
    }

    public boolean doDiff(Query query, String newCSV) {
        List<String> newLines;
        List<String> original = QueryVerifier.fileToLines(this.getCSVName(query, "CSV_EXPORT", ""));
        Patch patch = DiffUtils.diff(original, newLines = QueryVerifier.fileToLines(newCSV));
        if (patch.getDeltas().isEmpty()) {
            logger.info("Match: " + query.getId() + " with " + newCSV);
            return true;
        }
        logger.error("DIFF FAILED: " + query.getId() + " with " + newCSV);
        return false;
    }

    private static List<String> fileToLines(String filename) {
        LinkedList<String> lines = new LinkedList<String>();
        String line = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            while ((line = in.readLine()) != null) {
                lines.add(line);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExplainPlan(Query query) throws SQLException {
        Connection conn = null;
        ResultSet rs = null;
        Statement statement = null;
        StringBuilder buf = new StringBuilder();
        try {
            conn = this.pUtil.getConnection(query.getTenantId());
            statement = conn.prepareStatement("EXPLAIN " + query.getStatement());
            rs = statement.executeQuery();
            while (rs.next()) {
                buf.append(rs.getString(1).trim().replace(",", "-"));
            }
            statement.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        return buf.toString();
    }

    private String getFileName(Query query) throws FileNotFoundException {
        String tempExt = "";
        if (this.useTemporaryOutput) {
            tempExt = "_" + UUID.randomUUID().toString();
        }
        return this.getCSVName(query, this.directoryLocation, tempExt);
    }

    private String getCSVName(Query query, String directory, String tempExt) {
        String csvFile = directory + "/" + query.getId() + tempExt + Extension.CSV.toString();
        return csvFile;
    }

    private void ensureBaseDirExists() {
        File baseDir = new File(this.directoryLocation);
        if (!baseDir.exists()) {
            baseDir.mkdir();
        }
    }
}

