/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.schema;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.Collection;
import org.apache.phoenix.pherf.exception.FileLoaderException;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.util.ResourceList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaReader {
    private static final Logger logger = LoggerFactory.getLogger(SchemaReader.class);
    private final PhoenixUtil pUtil;
    private Collection<Path> resourceList;
    private final String searchPattern;
    private final ResourceList resourceUtil;

    public SchemaReader(String searchPattern) throws Exception {
        this(new PhoenixUtil(), searchPattern);
    }

    public SchemaReader(PhoenixUtil util, String searchPattern) throws Exception {
        this.pUtil = util;
        this.searchPattern = searchPattern;
        this.resourceUtil = new ResourceList("/datamodel");
        this.read();
    }

    public Collection<Path> getResourceList() {
        return this.resourceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applySchema() throws Exception {
        try (Connection connection = null;){
            connection = this.pUtil.getConnection();
            for (Path file : this.resourceList) {
                logger.info("\nApplying schema to file: " + file);
                this.pUtil.executeStatement(this.resourceToString(file), connection);
            }
        }
    }

    public String resourceToString(Path file) throws Exception {
        String line;
        String fName = "/datamodel/" + file.getFileName().toString();
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(fName)));
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }

    private void read() throws Exception {
        logger.debug("Trying to match resource pattern: " + this.searchPattern);
        System.out.println("Trying to match resource pattern: " + this.searchPattern);
        this.resourceList = null;
        this.resourceList = this.resourceUtil.getResourceList(this.searchPattern);
        logger.info("File resourceList Loaded: " + this.resourceList);
        System.out.println("File resourceList Loaded: " + this.resourceList);
        if (this.resourceList.isEmpty()) {
            throw new FileLoaderException("Could not load Schema Files");
        }
    }
}

