/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.schema.SchemaReader;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.util.ResourceList;
import org.apache.phoenix.pherf.workload.WorkloadExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pherf {
    private static final Logger logger = LoggerFactory.getLogger(Pherf.class);
    private static final Options options = new Options();
    private final String zookeeper;
    private final String scenarioFile;
    private final String schemaFile;
    private final String queryHint;
    private final Properties properties;
    private final boolean loadData;
    private final String dropPherfTablesRegEx;
    private final boolean executeQuerySets;
    private final boolean exportCSV;
    private final boolean diff;
    private final boolean monitor;
    private final int rowCountOverride;
    private final boolean listFiles;

    public Pherf(String[] args) throws Exception {
        PosixParser parser = new PosixParser();
        CommandLine command = null;
        HelpFormatter hf = new HelpFormatter();
        try {
            command = parser.parse(options, args);
        }
        catch (ParseException e) {
            hf.printHelp("Pherf", options);
            System.exit(1);
        }
        this.properties = Pherf.getProperties();
        this.dropPherfTablesRegEx = command.getOptionValue("drop", null);
        this.monitor = command.hasOption("m");
        String monitorFrequency = command.hasOption("m") && command.hasOption("monitorFrequency") ? command.getOptionValue("monitorFrequency") : this.properties.getProperty("pherf.default.monitorFrequency");
        this.properties.setProperty("pherf.default.monitorFrequency", monitorFrequency);
        logger.debug("Using Monitor: " + this.monitor);
        logger.debug("Monitor Frequency Ms:" + monitorFrequency);
        this.loadData = command.hasOption("l");
        this.executeQuerySets = command.hasOption("q");
        this.zookeeper = command.getOptionValue("z", "localhost");
        this.queryHint = command.getOptionValue("hint", null);
        this.exportCSV = command.hasOption("export");
        this.diff = command.hasOption("diff");
        this.listFiles = command.hasOption("listFiles");
        this.scenarioFile = command.hasOption("scenarioFile") ? command.getOptionValue("scenarioFile") : null;
        this.schemaFile = command.hasOption("schemaFile") ? command.getOptionValue("schemaFile") : null;
        this.rowCountOverride = Integer.parseInt(command.getOptionValue("rowCountOverride", "0"));
        String writerThreadPoolSize = command.getOptionValue("writerThreadSize", this.properties.getProperty("pherf.default.dataloader.threadpool"));
        this.properties.setProperty("pherf. default.dataloader.threadpool", writerThreadPoolSize);
        if ((command.hasOption("h") || args == null || args.length == 0) && !command.hasOption("listFiles")) {
            hf.printHelp("Pherf", options);
            System.exit(1);
        }
        PhoenixUtil.setZookeeper(this.zookeeper);
        PhoenixUtil.setRowCountOverride(this.rowCountOverride);
    }

    public static void main(String[] args) {
        try {
            new Pherf(args).run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        WorkloadExecutor workloadExec = null;
        try {
            if (this.listFiles) {
                ResourceList list = new ResourceList("/datamodel");
                Collection<Path> schemaFiles = list.getResourceList(".*.sql");
                System.out.println("Schema Files:");
                for (Path path : schemaFiles) {
                    System.out.println(path);
                }
                list = new ResourceList("/scenario");
                Collection<Path> scenarioFiles = list.getResourceList(PherfConstants.SCENARIO_ROOT_PATTERN + ".xml");
                System.out.println("Scenario Files:");
                for (Path path : scenarioFiles) {
                    System.out.println(path);
                }
                return;
            }
            WorkloadExecutor workloadExecutor = workloadExec = this.scenarioFile == null ? new WorkloadExecutor(this.properties, new XMLConfigParser(".*scenario.xml"), this.monitor) : new WorkloadExecutor(this.properties, new XMLConfigParser(this.scenarioFile), this.monitor);
            if (null != this.dropPherfTablesRegEx) {
                logger.info("\nDropping existing table with PHERF namename and " + this.dropPherfTablesRegEx + " regex expression.");
                new PhoenixUtil().deleteTables(this.dropPherfTablesRegEx);
            }
            if (this.loadData) {
                logger.info("\nStarting to apply schema...");
                SchemaReader reader = this.schemaFile == null ? new SchemaReader(".*.sql") : new SchemaReader(this.schemaFile);
                reader.applySchema();
                logger.info("\nStarting Data Load...");
                workloadExec.executeDataLoad();
                logger.info("\nGenerate query gold files after data load");
                workloadExec.executeMultithreadedQueryExecutor(this.queryHint, true, PherfConstants.RunMode.FUNCTIONAL);
            } else {
                logger.info("\nSKIPPED: Data Load and schema creation as -l argument not specified");
            }
            if (this.executeQuerySets) {
                logger.info("\nStarting to apply schema...");
                workloadExec.executeMultithreadedQueryExecutor(this.queryHint, this.exportCSV, this.diff ? PherfConstants.RunMode.FUNCTIONAL : PherfConstants.RunMode.PERFORMANCE);
            } else {
                logger.info("\nSKIPPED: Multithreaded query set execution as -q argument not specified");
            }
        }
        finally {
            if (workloadExec != null) {
                logger.info("Run completed. Shutting down Monitor if it was running.");
                workloadExec.shutdown();
            }
        }
    }

    private static Properties getProperties() throws Exception {
        ResourceList list = new ResourceList();
        return list.getProperties();
    }

    static {
        options.addOption("m", "monitor", false, "Launch the stats profilers");
        options.addOption("monitorFrequency", true, "Override for frequency in Ms for which monitor should log stats. \n See pherf.default.monitorFrequency in pherf.properties");
        options.addOption("d", "debug", false, "Put tool in debug mode");
        options.addOption("z", "zookeeper", true, "HBase Zookeeper address for connection. Default: localhost");
        options.addOption("l", "load", false, "Loads data according to specified configuration values.");
        options.addOption("scenarioFile", true, "Regex or file name for the Test Scenario configuration .xml file to use.");
        options.addOption("drop", true, "Regex drop all tables with schema name as PHERF. \nExample drop Event tables: -drop .*(EVENT).* Drop all: -drop .* or -drop all");
        options.addOption("schemaFile", true, "Regex or file name for the Test phoenix table schema .sql to use.");
        options.addOption("rowCountOverride", true, "Row count override to use instead of one specified in scenario.");
        options.addOption("hint", true, "Executes all queries with specified hint. Example SMALL");
        options.addOption("diff", false, "Run pherf in verification mode and diff with exported results");
        options.addOption("export", false, "Exports query results to CSV files in CSV_EXPORT directory");
        options.addOption("listFiles", false, "List available resource files");
        options.addOption("writerThreadSize", true, "Override the default number of writer threads. See pherf.default.dataloader.threadpool in Pherf.properties.");
        options.addOption("q", "query", false, "Executes multi-threaded query sets");
        options.addOption("h", "help", false, "Get help on using this utility.");
    }
}

