/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf;

import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.apache.phoenix.end2end.BaseHBaseManagedTimeIT;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.schema.SchemaReader;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.junit.Assert;
import org.junit.Test;

public class SchemaReaderIT
extends BaseHBaseManagedTimeIT {
    protected static PhoenixUtil util = new PhoenixUtil(true);

    @Test
    public void testSchemaReader() {
        this.assertApplySchemaTest();
    }

    private void assertApplySchemaTest() {
        try {
            PhoenixUtil.setZookeeper((String)"localhost");
            SchemaReader reader = new SchemaReader(util, ".*datamodel/.*test.*sql");
            ArrayList resources = new ArrayList(reader.getResourceList());
            Assert.assertTrue((String)"Could not pull list of schema files.", (resources.size() > 0 ? 1 : 0) != 0);
            Assert.assertNotNull((String)"Could not read schema file.", (Object)((Object)((Object)this)).getClass().getResourceAsStream("/datamodel/" + ((Path)resources.get(0)).getFileName().toString()));
            Assert.assertNotNull((String)"Could not read schema file.", (Object)reader.resourceToString((Path)resources.get(0)));
            reader.applySchema();
            Connection connection = null;
            URL resourceUrl = ((Object)((Object)this)).getClass().getResource("/scenario/test_scenario.xml");
            Assert.assertNotNull((String)"Test data XML file is missing", (Object)resourceUrl);
            connection = util.getConnection();
            Path resourcePath = Paths.get(resourceUrl.toURI());
            DataModel data = XMLConfigParser.readDataModel((Path)resourcePath);
            List scenarioList = data.getScenarios();
            Scenario scenario = (Scenario)scenarioList.get(0);
            List columnList = util.getColumnsFromPhoenix(scenario.getSchemaName(), scenario.getTableNameWithoutSchemaName(), connection);
            Assert.assertTrue((String)"Could not retrieve Metadata from Phoenix", (columnList.size() > 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail((String)"Could not initialize SchemaReader");
            e.printStackTrace();
        }
    }
}

