/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.DataSequence;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.loaddata.DataLoader;
import org.apache.phoenix.pherf.rules.DataValue;
import org.apache.phoenix.pherf.rules.RulesApplier;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Assert;
import org.junit.Test;

public class RuleGeneratorTest {
    static PhoenixUtil util = new PhoenixUtil(true);
    static final String matcherScenario = PherfConstants.SCENARIO_ROOT_PATTERN + ".xml";

    @Test
    public void testDateGenerator() throws Exception {
        XMLConfigParser parser = new XMLConfigParser(matcherScenario);
        DataModel model = (DataModel)parser.getDataModels().get(0);
        DataLoader loader = new DataLoader(parser);
        RulesApplier rulesApplier = loader.getRulesApplier();
        for (Column dataMapping : model.getDataMappingColumns()) {
            if (dataMapping.getType() != DataTypeMapping.DATE || !dataMapping.getName().equals("CREATED_DATE")) continue;
            this.assertRandomDateValue(dataMapping, rulesApplier);
            for (int i = 0; i < 20; ++i) {
                DataValue value = rulesApplier.getDataValue(dataMapping);
                Assert.assertNotNull((String)"Could not retrieve DataValue for random DATE.", (Object)value);
                Assert.assertNotNull((String)"Could not retrieve a value in DataValue for random DATE.", (Object)value.getValue());
                if (value.getMinValue() == null) continue;
                this.assertDateBetween(value);
            }
        }
    }

    @Test
    public void testNullChance() throws Exception {
        XMLConfigParser parser = new XMLConfigParser(matcherScenario);
        DataModel model = (DataModel)parser.getDataModels().get(0);
        DataLoader loader = new DataLoader(parser);
        RulesApplier rulesApplier = loader.getRulesApplier();
        int sampleSize = 100;
        ArrayList<String> values = new ArrayList<String>(sampleSize);
        for (Column dataMapping : model.getDataMappingColumns()) {
            DataValue value = rulesApplier.getDataValue(dataMapping);
            if (dataMapping.getNullChance() == 0) {
                Assert.assertFalse((String)"", (boolean)value.getValue().equals(""));
                continue;
            }
            if (dataMapping.getNullChance() == 100) {
                Assert.assertTrue((String)"", (boolean)value.getValue().equals(""));
                continue;
            }
            if (dataMapping.getNullChance() != 90) continue;
            for (int i = 0; i < sampleSize; ++i) {
                DataValue tVal = rulesApplier.getDataValue(dataMapping);
                values.add(tVal.getValue());
            }
            Collections.sort(values);
        }
    }

    @Test
    public void testSequentialDataSequence() throws Exception {
        XMLConfigParser parser = new XMLConfigParser(matcherScenario);
        DataModel model = (DataModel)parser.getDataModels().get(0);
        DataLoader loader = new DataLoader(parser);
        RulesApplier rulesApplier = loader.getRulesApplier();
        Column targetColumn = null;
        for (Column column : model.getDataMappingColumns()) {
            DataSequence sequence = column.getDataSequence();
            if (sequence != DataSequence.SEQUENTIAL) continue;
            targetColumn = column;
            break;
        }
        Assert.assertNotNull((String)"Could not find a DataSequence.SEQENTIAL rule.", targetColumn);
        this.assertMultiThreadedIncrementValue(targetColumn, rulesApplier);
    }

    private void assertRandomDateValue(Column dataMapping, RulesApplier rulesApplier) throws Exception {
        List dataValues = dataMapping.getDataValues();
        DataValue ruleValue = (DataValue)dataValues.get(2);
        String dt = rulesApplier.generateRandomDate(ruleValue.getMinValue(), ruleValue.getMaxValue());
        ruleValue.setValue(dt);
        this.assertDateBetween(ruleValue);
    }

    private void assertMultiThreadedIncrementValue(final Column column, final RulesApplier rulesApplier) throws Exception {
        int threadCount = 30;
        int increments = 100;
        final TreeSet testSet = new TreeSet();
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        for (int i = 0; i < 30; ++i) {
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    for (int i = 0; i < 100; ++i) {
                        try {
                            DataValue value = rulesApplier.getDataValue(column);
                            String strValue = value.getValue();
                            Set set = testSet;
                            synchronized (set) {
                                Assert.assertFalse((String)("Incrementer gave a duplicate value: " + strValue), (boolean)testSet.contains(strValue));
                                Assert.assertTrue((String)"Length did not equal expected.", (strValue.length() == column.getLength() ? 1 : 0) != 0);
                                testSet.add(strValue);
                                continue;
                            }
                        }
                        catch (Exception e) {
                            Assert.fail((String)("Caught an exception during test: " + e.getMessage()));
                        }
                    }
                }
            };
            t.start();
            threadList.add(t);
        }
        for (Thread t : threadList) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Assert.fail((String)("There was a problem reading thread: " + e.getMessage()));
            }
        }
        Assert.assertTrue((String)"Expected count in increments did not match expected", (testSet.size() == 3000 ? 1 : 0) != 0);
    }

    @Test
    public void testValueListRule() throws Exception {
        ArrayList<String> expectedValues = new ArrayList<String>();
        expectedValues.add("aAAyYhnNbBs9kWk");
        expectedValues.add("bBByYhnNbBs9kWu");
        expectedValues.add("cCCyYhnNbBs9kWr");
        XMLConfigParser parser = new XMLConfigParser(".*test_scenario.xml");
        DataLoader loader = new DataLoader(parser);
        RulesApplier rulesApplier = loader.getRulesApplier();
        Scenario scenario = (Scenario)parser.getScenarios().get(0);
        Column simPhxCol = new Column();
        simPhxCol.setName("PARENT_ID");
        simPhxCol.setType(DataTypeMapping.CHAR);
        for (int i = 0; i < 10; ++i) {
            DataValue value = rulesApplier.getDataForRule(scenario, simPhxCol);
            Assert.assertTrue((String)("Got a value not in the list for the rule. :" + value.getValue()), (boolean)expectedValues.contains(value.getValue()));
        }
    }

    private void assertDateBetween(DataValue value) {
        DateTimeFormatter fmtr = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS");
        DateTime dt = fmtr.parseDateTime(value.getValue());
        DateTime min = fmtr.parseDateTime(value.getMinValue());
        DateTime max = fmtr.parseDateTime(value.getMaxValue());
        Assert.assertTrue((String)("Value " + dt + " is not after minValue"), (boolean)dt.isAfter((ReadableInstant)min));
        Assert.assertTrue((String)("Value " + dt + " is not before maxValue"), (boolean)dt.isBefore((ReadableInstant)max));
    }
}

