/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Properties;
import org.apache.phoenix.pherf.PherfConstants;
import org.apache.phoenix.pherf.util.ResourceList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ResourceTest {
    @Test
    public void testSchemaResourceList() throws Exception {
        String extension = ".sql";
        this.assertResources(".*" + extension, "/datamodel", extension);
    }

    @Test
    public void testScenarioResourceList() throws Exception {
        String extension = ".xml";
        this.assertResources(PherfConstants.SCENARIO_ROOT_PATTERN + extension, "/scenario", extension);
    }

    @Test
    public void testResourceListPropertyDirectory() throws Exception {
        ResourceList list = new ResourceList();
        Properties properties = list.getProperties();
        Assert.assertTrue((String)"Property file list was empty", (properties.size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)properties.getProperty("pherf.default.dataloader.threadpool"));
    }

    private Collection<Path> assertResources(String pattern, String rootDir, String assertStr) throws Exception {
        ResourceList list = new ResourceList(rootDir);
        Collection paths = list.getResourceList(pattern);
        Assert.assertTrue((String)"Resource file list was empty", (paths.size() > 0 ? 1 : 0) != 0);
        for (Path path : paths) {
            Assert.assertThat((Object)path.toString(), (Matcher)CoreMatchers.containsString((String)assertStr));
        }
        return paths;
    }
}

