/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.phoenix.end2end.BaseHBaseManagedTimeIT;
import org.apache.phoenix.pherf.configuration.Column;
import org.apache.phoenix.pherf.configuration.DataTypeMapping;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.loaddata.DataLoader;
import org.apache.phoenix.pherf.rules.DataValue;
import org.apache.phoenix.pherf.rules.RulesApplier;
import org.apache.phoenix.pherf.schema.SchemaReader;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.junit.Assert;
import org.junit.Test;

public class DataIngestIT
extends BaseHBaseManagedTimeIT {
    protected static PhoenixUtil util = new PhoenixUtil(true);
    static final String matcherScenario = ".*scenario/.*test.*xml";
    static final String matcherSchema = ".*datamodel/.*test.*sql";

    @Test
    public void generateData() throws Exception {
        PhoenixUtil.setZookeeper((String)"localhost");
        SchemaReader reader = new SchemaReader(util, matcherSchema);
        XMLConfigParser parser = new XMLConfigParser(matcherScenario);
        ArrayList resources = new ArrayList(reader.getResourceList());
        Assert.assertTrue((String)"Could not pull list of schema files.", (resources.size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"Could not read schema file.", (Object)reader.resourceToString((Path)resources.get(0)));
        reader.applySchema();
        Scenario scenario = (Scenario)parser.getScenarios().get(0);
        List columnListFromPhoenix = util.getColumnsFromPhoenix(scenario.getSchemaName(), scenario.getTableNameWithoutSchemaName(), util.getConnection());
        Assert.assertTrue((String)"Could not get phoenix columns.", (columnListFromPhoenix.size() > 0 ? 1 : 0) != 0);
        DataLoader loader = new DataLoader(util, parser);
        RulesApplier rulesApplier = loader.getRulesApplier();
        List modelList = rulesApplier.getModelList();
        Assert.assertTrue((String)"Could not generate the modelList", (modelList.size() > 0 ? 1 : 0) != 0);
        for (Column column : columnListFromPhoenix) {
            DataValue data = rulesApplier.getDataForRule(scenario, column);
            Assert.assertTrue((String)("Failed to retrieve data for column type: " + column.getType()), (data != null ? 1 : 0) != 0);
            if (column.getType() != DataTypeMapping.VARCHAR || !column.getName().equals("NEWVAL_STRING")) continue;
            Assert.assertTrue((String)"Failed to retrieve data for column type: ", (data.getDistribution() == Integer.MIN_VALUE ? 1 : 0) != 0);
        }
        try {
            loader.execute();
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to lead data. An exception was thrown: " + e.getMessage()));
        }
    }
}

